<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_AndroidManagement_NetworkInfo extends Google_Collection
{
  protected $collection_key = 'telephonyInfos';
  public $imei;
  public $meid;
  public $networkOperatorName;
  protected $telephonyInfosType = 'Google_Service_AndroidManagement_TelephonyInfo';
  protected $telephonyInfosDataType = 'array';
  public $wifiMacAddress;

  public function setImei($imei)
  {
    $this->imei = $imei;
  }
  public function getImei()
  {
    return $this->imei;
  }
  public function setMeid($meid)
  {
    $this->meid = $meid;
  }
  public function getMeid()
  {
    return $this->meid;
  }
  public function setNetworkOperatorName($networkOperatorName)
  {
    $this->networkOperatorName = $networkOperatorName;
  }
  public function getNetworkOperatorName()
  {
    return $this->networkOperatorName;
  }
  /**
   * @param Google_Service_AndroidManagement_TelephonyInfo[]
   */
  public function setTelephonyInfos($telephonyInfos)
  {
    $this->telephonyInfos = $telephonyInfos;
  }
  /**
   * @return Google_Service_AndroidManagement_TelephonyInfo[]
   */
  public function getTelephonyInfos()
  {
    return $this->telephonyInfos;
  }
  public function setWifiMacAddress($wifiMacAddress)
  {
    $this->wifiMacAddress = $wifiMacAddress;
  }
  public function getWifiMacAddress()
  {
    return $this->wifiMacAddress;
  }
}
