function agregarEventoClickClasesResaltarFila(idTabla) {
    $('#' + idTabla + ' tbody').on('click', 'tr', function () {
        marcarOdesmarcarFilaResaltada(this);
    });
}

function marcarOdesmarcarFilaResaltada(objFila) {
    if ($(objFila).hasClass('filaSeleccionada')) {

    } else {
        $(objFila).toggleClass('filaResaltada');
        resaltar_fila();
    }
}

function agregarEventoClickClasesResaltarUnaSolaFila(idTabla, tablaGenerada) {
    $('#' + idTabla + ' tbody').on('click', 'tr', function () {
        if ($(this).hasClass('filaResaltada')) {
            $(this).removeClass('filaResaltada');
        } else {
            tablaGenerada.$('tr.filaResaltada').removeClass('filaResaltada');
            $(this).addClass('filaResaltada');
        }
    });
}

function marcarOdesmarcarFilaSeleccionada(objFila) {
    $(objFila).toggleClass('filaSeleccionada');
}
function marcarFilaSeleccionada(objFila) {
    if ($(objFila).hasClass('filaResaltada')) {
        $(objFila).removeClass('filaResaltada');
    }    
    $(objFila).addClass('filaSeleccionada');
    seleccionar_fila();
}
function desmarcarFilaSeleccionada(objFila) {
    $(objFila).removeClass('filaSeleccionada');
    deseleccionar_fila();
}


function crearTabla(idTabla) {
    var tablaGenerada = $('#' + idTabla).dataTable();
    agregarEventoClickClasesResaltarFila(idTabla);
    return tablaGenerada;
}

function crearTablaParaDescargaDatos(idTabla, alto = 420) {
    return $('#' + idTabla).dataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        "language": {
            "url": "libs/json/espagniol.json"
        },
        "paging": false,
        "info": false,
        "scrollY": alto,
        "scrollX": false
    });
}

function crearTablaBasica(idTabla) {
    return $('#' + idTabla).dataTable({
        "paging": false,
        "ordering": false,
        "info": false
    });
}

function crearTablaCompleta(idTabla) {
    return $('#' + idTabla).dataTable({});
}

function crearTablaVertical(idTabla, alto = 420) {
    var tablaGenerada = $('#' + idTabla).dataTable({
        "paging": false,
        "info": false,
        "scrollY": "" + alto + "px",
        "scrollX": true
    });
    agregarEventoClickClasesResaltarFila(idTabla);
    return tablaGenerada;
}

function crearTablaScroll(idTabla, alto = 420, columnaOrden = 1) {
    var tablaGenerada = $('#' + idTabla).dataTable({
        "scrollY": "" + alto + "px",
        "scrollX": true,
        "scrollCollapse": true,
        "paging": false,
        "info": false,
        "order": [[columnaOrden, "desc"]]
    });
    agregarEventoClickClasesResaltarFila(idTabla);
    return tablaGenerada;
}

function crearTablaScrollSinResaltado(idTabla, alto = 420, columnaOrden = 1) {
    var tablaGenerada = $('#' + idTabla).dataTable({
        "scrollY": "" + alto + "px",
        "scrollX": true,
        "scrollCollapse": true,
        "paging": false,
        "info": false,
        "order": [[columnaOrden, "desc"]]
    });
    return tablaGenerada;
}

function crearTablaScrollVertical(idTabla, alto = 420) {
    var tablaGenerada = $('#' + idTabla).dataTable({
        "scrollY": "" + alto + "px",
        "scrollCollapse": true,
        "paging": false
    });
    agregarEventoClickClasesResaltarFila(idTabla);
    return tablaGenerada;
}

function activarSeleccionarTodosClase(classCheckBoxSeleccionarTodos, claseCheckBoxes) {
    $("." + classCheckBoxSeleccionarTodos).on('ifChecked', function (event) {
        seleccionarTodosRegistros(claseCheckBoxes);
    });
    $("." + classCheckBoxSeleccionarTodos).on('ifUnchecked', function (event) {
        deseleccionarTodosRegistros(claseCheckBoxes);
    });
}

function activarSeleccionarTodos(idCheckBoxSeleccionarTodos, claseCheckBoxes) {
    $("#" + idCheckBoxSeleccionarTodos).on('ifChecked', function (event) {
        seleccionarTodosRegistros(claseCheckBoxes);
    });
    $("#" + idCheckBoxSeleccionarTodos).on('ifUnchecked', function (event) {
        deseleccionarTodosRegistros(claseCheckBoxes);
    });
}

function seleccionarTodosRegistros(claseCheckBoxes) {
    $("." + claseCheckBoxes).iCheck('check');
}

function deseleccionarTodosRegistros(claseCheckBoxes) {
    $("." + claseCheckBoxes).iCheck('uncheck');
}

function registrosSeleccionadosDivision(idTablaListado) {
    return $('#' + idTablaListado + ' input:checked');
}

function registrosSeleccionadosTabla(idTabla) {
    var oTable = $('#' + idTabla).DataTable();
    var seleccion = oTable.$("input[type='checkbox']").serializeArray();
    return seleccion;
}
function registrosRadiosSeleccionadosTabla(idTabla) {
    var oTable = $('#' + idTabla).DataTable();
    var seleccion = oTable.$("input[type='radio']").serializeArray();
    return seleccion;
}


//
///
///
/////
/////
///////
///////
///////
//////////
/////////////
////////////////
/////////////////////



function seleccionadoEnTabla(idFormConTabla, operacion) {
    var seleccionados = unoSoloSeleccionadoTabla(idFormConTabla, operacion);
    if (seleccionados) {
        return  seleccionados.value;
    }
    return null;
}
function variosSeleccionadosEnTabla(idFormConTabla, operacion) {
    var seleccionados = unoSoloSeleccionadoTabla(idFormConTabla, operacion);
    if (seleccionados) {
        return seleccionados;
    }
    return null;
}

function unoSoloSeleccionadoTabla(idFormConTabla, operacion) {
    var seleccionados = registrosSeleccionadosTablaDentroObjeto(idFormConTabla);
    if (seleccionados.length == 1) {
        return seleccionados[0];
    } else {
        if (seleccionados.length == 0) {
            alertaInformacion("Debes seleccionar un registro para [" + operacion.toUpperCase() + "].");
            return null;
        } else {
            alertaPrevencion("Debes seleccionar SOLO UN registro para [" + operacion.toUpperCase() + "].");
            return null;
        }
    }
    return seleccionados;
}

function registrosSeleccionadosTablaDentroObjeto(idObjeto) {
    var oTable = $('#' + idObjeto + ' table').DataTable();
    var seleccion = oTable.$("input[type='checkbox']").serializeArray();
    return seleccion;
}


/**
 * Verifica que se haya selecionado solo un registro en la tabla contenida
 * en el formulario {idFormConTabla}     
 * @param {String} idFormConTabla id del formulario que contiene la tabla con los registros
 * @param {String} operacion Nombre de la operación que se va ha realizar con el registro seleccionado.
 * @returns {Element} Checkbox seleccionado
 */

function radioSeleccionadoTabla(idFormConTabla, operacion) {
    var seleccionados = registrosRadiosSeleccionadosTabla(idFormConTabla);
    if (seleccionados.length == 1) {
        return seleccionados[0];
    } else {
        if (seleccionados.length == 0) {
            alertaInformacion("Debes seleccionar un registro para [" + operacion.toUpperCase() + "].");
            return null;
        } else {
            alertaPrevencion("Debes seleccionar SOLO UN registro para [" + operacion.toUpperCase() + "].");
            return null;
        }
    }
    return seleccionados;
}

function unoSoloSeleccionadoTabla(idFormConTabla, operacion) {
    var seleccionados = registrosSeleccionadosTabla(idFormConTabla);
    if (seleccionados.length == 1) {
        return seleccionados[0];
    } else {
        if (seleccionados.length == 0) {
            alertaInformacion("Debes seleccionar un registro para [" + operacion.toUpperCase() + "].");
            return null;
        } else {
            alertaPrevencion("Debes seleccionar SOLO UN registro para [" + operacion.toUpperCase() + "].");
            return null;
        }
    }
    return seleccionados;
}

function unoSoloSeleccionadoVariasTablas(idsTablas = [], operacion) {
    var seleccionados = seleccionadosEnVariasTablas(idsTablas);
    if (seleccionados.length == 1) {
        return seleccionados[0];
    } else {
        if (seleccionados.length == 0) {
            alertaInformacion("Debes seleccionar un registro para [" + operacion.toUpperCase() + "].");
            return null;
        } else {
            alertaPrevencion("Debes seleccionar SOLO UN registro para [" + operacion.toUpperCase() + "].");
            return null;
        }
    }
    return seleccionados;
}

function unoSoloSeleccionadoDiv(idDiv, operacion) {
    var seleccionados = $("#" + idDiv + " input:checked");
    if (seleccionados.length == 1) {
        return seleccionados[0];
    } else {
        if (seleccionados.length == 0) {
            alertaInformacion("Debes seleccionar un registro para [" + operacion.toUpperCase() + "].");
            return null;
        } else {
            alertaPrevencion("Debes seleccionar SOLO UN registro para [" + operacion.toUpperCase() + "].");
            return null;
        }
    }
    return seleccionados.serialize();
}

function seleccionadosEnVariasTablas(idsTablas = []) {
    var seleccionados = Array();
    idsTablas.forEach(function (currentValue, index, arr) {
        var seleccionadosTabla = registrosSeleccionadosTabla(currentValue);
        seleccionados = seleccionados.concat(seleccionadosTabla);
    });
    return seleccionados;
}
/**
 * Verifica que haya uno o más registros seleccionado, en la tabla contenida
 * en el formulario {idFormConTabla}
 * @param {String} idFormConTabla id del formulario que contiene la tabla con los registros
 * @param {String} operacion Nombre de la operación que se va ha realizar con los registros seleccionados.
 * @returns {Array} Elementos Checkbox seleccionados.
 */
function variosSeleccionadosTabla(idFormConTabla, operacion) {
    var seleccionados = registrosSeleccionadosTabla(idFormConTabla);
    if (seleccionados.length >= 1) {
        return seleccionados;
    } else {
        alertaPrevencion("Debes seleccionar, al menos, un registro para [" + operacion.toUpperCase() + "] .");
        return null;
    }
    return seleccionados.serialize();
}

function variosSeleccionadosDiv(idDiv, operacion) {
    var seleccionados = $("#" + idDiv + " input:checked");
    if (seleccionados.length >= 1) {
        return seleccionados;
    } else {
        alertaPrevencion("Debes seleccionar, al menos, un registro para [" + operacion.toUpperCase() + "] .");
        return null;
    }
    return seleccionados.serialize();
}

function variosSeleccionadosHidden(idDivHiddens, operacion) {
    var seleccionados = $("#" + idDivHiddens + " input[type='hidden']");
    if (seleccionados.length >= 1) {
        return seleccionados;
    } else {
        alertaPrevencion("Debes seleccionar, al menos, un registro para [" + operacion.toUpperCase() + "] .");
        return null;
    }
    return seleccionados.serialize();
}

function variosSeleccionadosVariasTablas(idsTablas = [], operacion) {
    var seleccionados = seleccionadosEnVariasTablas(idsTablas);
    if (seleccionados.length >= 1) {
        return seleccionados;
    } else {
        alertaInformacion("Debes seleccionar, al menos, un registro para [" + operacion.toUpperCase() + "] .");
        return null;
    }
    return seleccionados.serialize();
}

function agregarFilaTabla(idTabla, datosFila, idRow = null) {
    var table = $('#' + idTabla).DataTable();
    console.log(table);
    var rowNode = table.row.add(datosFila).draw().node();
    if (idRow != null) {
        $(rowNode).attr('id', idRow);
    }
    $(rowNode).css('color', 'red').animate({color: 'black'});
}

function quitarFilaTabla(idTabla, idRow) {
    var table = $(idTabla).DataTable();
    if ($(idTabla + " tr#" + idRow).length) {
        table.row($(idTabla + " tr#" + idRow)).remove().draw();
    }
}

function checkSelecionados(idTabla, serialize = false) {
    var oTable = $('#' + idTabla).DataTable();
    if (!serialize) {
        var seleccion = oTable.$("input[type='checkbox']").serializeArray();
    } else {
        var seleccion = oTable.$("input[type='checkbox']").serialize();
    }
    return seleccion;
}

function validacionCheckbox(checkSeleccionados, funcionEjecutable, maxUno = true) {
    if (checkSeleccionados.length == 0) {
        swal("Error!", 'NO HA SELECCIONADO NINGUNA OPCIÓN', "error");
    } else {
        if (maxUno) {
            if (checkSeleccionados.length > 1) {
                swal("Error!", 'HA SELECCIONADO MAS OPCIONES DE LO PERMITIDO', "error");
            } else {
                funcionEjecutable();
            }
        } else {
            funcionEjecutable();
        }
}
}

function totalesTablaEnColumna(tabla, columnaSuma, columnaTotal, row, data, start, end, display) {
    var api = tabla.api(),
            data;
    // Remove the formatting to get integer data for summation
    var intVal = function (i) {
        return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
    };
    // Total over all pages
    total = api.column(columnaSuma).data().reduce(function (a, b) {
        return intVal(a) + intVal(b);
    }, 0);
    // Total over this page
    pageTotal = api.column(columnaSuma, {page: 'current'}).data().reduce(function (a, b) {
        return intVal(a) + intVal(b);
    }, 0);
    // Update footer
    $(api.column(columnaTotal).footer()).html(formatoMoneda(pageTotal)
            //+ ' ( $'+ total +' total)'
            );
}

function activarEdicionEnTabla(idTabla, componente = '', controlador = '', operacion = '', funcion = null){
    var contenidoEditable = '';

    $('#' + idTabla + ' tbody td').on('click', function () {
        if ($(this).find('input').length > 0 || !$(this).data('type')) return;

        contenidoEditable = $(this).text().trim();

        var esDescripcion = $(this).data('description') !== undefined;
        if(esDescripcion){
            contenidoEditable = $(this).data('description').trim();
        }
        var valorAntiguo = contenidoEditable;
        var esNumerico = $(this).data('type') === "number";
        var esMoneda = contenidoEditable.includes("$");
        if (esNumerico) {
            contenidoEditable = contenidoEditable.replace(/[^0-9]/g, '');
        }

        var input = $('<input type="' + $(this).data('type') + '" class="form-control">').val(contenidoEditable);
        $(this).html(input);
        input.focus();

        var td = $(this);
        var tr = td.closest('tr');

        input.blur(function () {
            var nuevoValor = $(this).val().trim();
            var valorEscribir = nuevoValor !== contenidoEditable ? nuevoValor : contenidoEditable;
            if(esNumerico){
                valorEscribir = formatoMoneda(valorEscribir);
            }
            if(esMoneda){
                valorEscribir = '$ ' + valorEscribir;
            }

            if(nuevoValor !== contenidoEditable){
                var datos = {};
                datos[tr.data('campo')] = tr.data('valor');
                td.text(valorEscribir);
                if(esDescripcion) td.data('description', valorEscribir);
                tr.find('td').each(function () {
                    if ($(this).data('type')) {
                        datos[$(this).data('campo')] = $(this).data('type') === 'number' ? $(this).text().trim().replace(/[^0-9]/g, '') : $(this).data('description')??$(this).text().trim();
                    }
                });

                td.text(valorAntiguo.substring(0, td.data('largo')) + (esDescripcion ? '...' : ''));
                if(esDescripcion) td.data('description', valorAntiguo);

                ejecutarOperacionOculta(componente, controlador, operacion, $.param(datos), function(respuesta){
                    td.text(valorEscribir.substring(0, td.data('largo')) + (esDescripcion ? '...' : ''));
                    if(esDescripcion){
                        td.data('description', valorEscribir);
                        td.tooltipster('content', valorEscribir);
                    }
                    if(td.data('campo').includes("CODIGO")){
                        td.text(respuesta.Codigo);
                    }
                    td.css('color', 'red').animate({color: 'black'});
                    if(funcion != null){
                        funcion(respuesta);
                    }
                });
            }else{
                td.text(valorEscribir.substring(0, td.data('largo')) + (esDescripcion ? '...' : ''));
            }
        });

        input.keypress(function (e) {
            if (e.which == 13) {
                $(this).blur();
            }
        });
    });
}