<?php
$function = new \Twig\TwigFunction('parametro', function ($PARAMETRO) {
      return Parametros::valor($PARAMETRO);
  });
$twig->addFunction($function);

$function = new \Twig\TwigFunction('botonesSinTexto', function ($texto) {
      Botones::sinTexto($texto);
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('boton', function ($tipo, $operacion = null, $funcion = null, $texto = null, $icono = null, $clase = null) {
      if (is_null($texto)):
          echo Botones::$tipo($operacion, $funcion);
      else:
          echo Botones::$tipo($operacion, $funcion, $texto, $icono, $clase);
      endif;
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('imagenTooltip', function ($idElemento, $srcImagen) {
      if (empty($srcImagen)) {
          echo '<div class="titulo-flotante" data-tooltip-content="#' . $idElemento . '"  title="NO TIENE IMAGEN ASOCIADA" ><i class="fa fa-times" aria-hidden="true"></i></div>';
      } else {
          echo '<div class="titulo-flotante" data-tooltip-content="#' . $idElemento . '" ><i class="fa fa-picture-o" aria-hidden="true"></i>';
          echo '<div class="tooltip_imagen">' .
          '<span id="' . $idElemento . '">' . '<img src="' . $srcImagen . '" />' . '</span>' .
          ' <small class="text-center" >' . $srcImagen . '</small> ' .
          '</div>';
          echo '</div>';
      }
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('pdfTooltip', function ($idElemento, $srcPDF) {

      if (empty($srcPDF)) {
          echo '<div class="titulo-flotante" data-tooltip-content="#' . $idElemento . '" title="NO TIENE UN DOCUMENTO ASOCIADO" ><i class="fa fa-times" aria-hidden="true"></i></div>';
      } else {
          echo '<div class="titulo-flotante" data-tooltip-content="#' . $idElemento . '" ><i class="fa fa-file-pdf-o fa-lg" aria-hidden="true"></i>';
          echo '<div class="tooltip_imagen">' .
          '<span id="' . $idElemento . '">' .
          '<iframe src="' . $srcPDF . '" style="border:0px #ffffff none;" name="myiFrame" scrolling="no" frameborder="1" marginheight="0px" marginwidth="0px" height="400px" width="600px" allowfullscreen></iframe>' .
          ' <br /><small class="text-center" >' . $srcPDF . '</small> ' .
          '</span>' .
          '</div>';
          echo '</div>';
      }
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('labelEstado', function ($estadoCODIGO, $estadoTITULO = '') {
      if (empty($estadoTITULO)) {
          $estadoTITULO = $estadoCODIGO;
      }
      echo '<span class="label label-default label-' . $estadoCODIGO . '">' . $estadoTITULO . '</span>';
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('enlace', function ($enlaceURL, $enlaceTITULO = '') {
      if (!empty($enlaceURL)) {
          echo '<a class="btn-link" href="javascript:void(0)" onclick="copiarAlPortapapelesTEXTO(\'' . $enlaceURL . '\');"  title="clic para copiar ' . $enlaceURL . '" ><i class="fa fa-copy" aria-hidden="true"></i></a>&nbsp; ';
          echo '<a class="btn-link" href="javascript:void(0)" onclick="popUp(\'' . htmlspecialchars($enlaceURL) . '\', \'' . $enlaceURL . '\');" title="clic para ir a ' . $enlaceURL . '"  >' . $enlaceTITULO . '<i class="fa fa-external-link" aria-hidden="true"></i></a>';
      } else {
          echo '<div class="titulo-flotante" data-tooltip-content="#" title="NO TIENE ENLACE ASOCIADO"  ><i class="fa fa-chain-broken" aria-hidden="true" title="NO TIENE ENLACE ASOCIADO"  ></i></div>';
      }
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('mostrarVista', function ($componente, $vista, $datos = array()) {
      Vistas::mostrar(strtolower($componente), $vista, $datos);
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('tableTooltip', function ($idElemento, $componente, $controlador, $operacion, $datos = null) {
      echo '<div class="titulo-flotante" id="' . $idElemento . '" ><i class="fa fa-table fa-lg" aria-hidden="true"></i>';
      echo '<script type="text/javascript" >' .
      '$("#' . $idElemento . '").tooltipster({' .
      'content: "Cargando...",' .
      'contentAsHTML: true, ' .
      'functionBefore: function(instance, helper) {' .
      'var $origin = $(helper.origin);' .
      'if ($origin.data("loaded") != true) {' .
      'ejecutarOperacionHTML(' .
      '"' . $componente . '", "' . $controlador . '", "' . $operacion . '", "' . $datos . '",' .
      'function (html) {' .
      'instance.content(html);' .
      '$origin.data("loaded", true);' .
      '}, false);' .
      '}' .
      '}' .
      '});' .
      '</script>';
      echo '</div>';
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('existeURL', function ($archivoURL) {
      $curl = curl_init($archivoURL);
      curl_setopt($curl, CURLOPT_NOBODY, true);
      $result = curl_exec($curl);
      if (false !== $result) {
          $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
          if (404 == $statusCode) {
              return false;
          } else {
              return true;
          }
      } else {
          return false;
      }
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('busquedaObjArray', function ($array, $index, $valor) {
      if (is_array($array)) {
          if (count($array)) {
              foreach ($array as $arrayInf) {
                  if (!empty($arrayInf->{$index})) {
                      if ($arrayInf->{$index} == $valor) {
                          return $arrayInf;
                      }
                  }
              }
          }
      }
      return null;
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('arrayAstring', function ($array, $index) {
      $str = '';
      if (count($array)) {
          foreach ($array as $arrayInf) {
              if (!empty($arrayInf->{$index})) {
                  $str .= $arrayInf->{$index} . ', ';
              }
          }
          return $str;
      }
      return null;
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('mesesEspanol', function ($numMes) {
      return Fechas::mesEspanol($numMes);
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('fecha', function ($fecha, $formato = Fechas::FECHA_DIA_SEMANA ) {
      return Fechas::convertirFecha2Texto($fecha, $formato);
  });
$twig->addFunction($function);
$function = new \Twig\TwigFunction('tiempo', function ($fecha, $formato = Fechas::SOLO_HORA_MINUTOS ) {
      return Fechas::convertirFecha2Texto($fecha, $formato);
  });
$twig->addFunction($function);

$function = new \Twig\TwigFunction('generarQR', function ($TEXTO = "") {
      return 'https://quickchart.io/qr?size=350&text='.$TEXTO;
  });
$twig->addFunction($function);



$function = new \Twig\TwigFunction('seleccionarValorPorDefecto', function ( $tipo, $nombre,  $valor ) {
      echo Formularios::$tipo($nombre, $valor);
  });
$twig->addFunction($function);
