<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Visitante
 *
 * @author root
 */
//*require_once './libs/GoogleAuth.php';
$googleClient = new Google_Client();
$auth = new GoogleAuth($googleClient);

class Visitante {

//put your code here

    var $nombre;
    var $correo;
    var $cedula;

    public static function nombre() {
        return isset($_SESSION['Colaborador']) ? $_SESSION['Colaborador']->personaNOMBRES . " " . $_SESSION['Colaborador']->personaAPELLIDOS : null;
    }

    public static function app($App = null) {
        if (is_null($App)) {
            return $_SESSION['App'];
        } else {
            self::datoSession('App', $App);
        }
    }

    public static function correo() {
        return isset($_SESSION['Colaborador']) ? $_SESSION['Colaborador']->colaboradorEMAIL : null;
    }

    public static function cedula() {
        return isset($_SESSION['Colaborador']) ? $_SESSION['Colaborador']->personaIDENTIFICACION : null;
    }

    static function comoInvitado() {
        $_SESSION['INVITADO'] = 1;
    }

    static function esInvitado() {
        if ($_SESSION['INVITADO'] == 1):
            return true;
        endif;
        return false;
    }

    static function dioPermisoGoogle() {
        global $auth;
        $payload = $auth->getPayload();
        return isset($payload['email']);
    }

    static function emailPermisoGoogle() {
        global $auth;
        $payload = $auth->getPayload();
        return ($payload['email']);
    }

    static function codigoRediccionValido() {
        global $auth;
        if ($auth->checkRedirectCode()) {
            if (isset($_GET['code'])) {
                $payload = $auth->getPayload();
                return isset($payload['email']);
            } else {
                return FALSE;
            }
        }
        return FALSE;
    }

    static function cargarDatosUsuario($correo = null) {
        $Usuario = Usuarios::porUsername(is_null($correo) ? self::correo() : $correo);
        if (!empty($Usuario)) {
            $_SESSION['Usuario'] = $Usuario;
            $_SESSION['Colaborador'] = Colaboradores::datosCompletosPorUsuario($Usuario->usuarioID);
            $_SESSION['INVITADO'] = 0;
        }
        return null;
    }

    static function estaLogueado() {
        if (empty(self::correo()) or is_null(self::correo())) {
            return false;
        }
        return true;
    }

    static function urlLoguearse() {
        global $auth;
        return $auth->getAuthUrl();
    }

    static function ip() {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP')) {
            $ipaddress = getenv('HTTP_CLIENT_IP');
        } else if (getenv('HTTP_X_FORWARDED_FOR')) {
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        } else if (getenv('HTTP_X_FORWARDED')) {
            $ipaddress = getenv('HTTP_X_FORWARDED');
        } else if (getenv('HTTP_FORWARDED_FOR')) {
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        } else if (getenv('HTTP_FORWARDED')) {
            $ipaddress = getenv('HTTP_FORWARDED');
        } else if (getenv('REMOTE_ADDR')) {
            $ipaddress = getenv('REMOTE_ADDR');
        } else {
            $ipaddress = 'DESCONOCIDA';
        }
        return $ipaddress;
    }

    static function datoSession($nombre, $valor = NULL) {
        if (is_null($valor)) {
            if (isset($_SESSION[$nombre])) {
                return $_SESSION[$nombre];
            } else {
                return NULL;
            }
        } else {
            session_start();
            $_SESSION["" . $nombre . ""] = $valor;
            session_write_close();
        }
    }

}

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoogleAuth
 *
 * @author Desarrollo
 */
class GoogleAuth {

    protected $client;

    public function __construct(Google_Client $googleClient = null) {
        $this->client = $googleClient;
        $secretAuth = Parametros::valor('SECRETAUTH');
        $ClientId = Parametros::valor('IDTAUTH');
        $RedirectUri = Parametros::valor('URLREDIRECTAUTH');

        if ($this->client) {
            $this->client->setClientId($ClientId);
            $this->client->setClientSecret($secretAuth);
            $this->client->setRedirectUri($RedirectUri);
            $this->client->setScopes('email');
        }
    }

    public function isLogedIn() {
        return isset($_SESSION['access_token']);
    }

    public function getAuthUrl() {
        return $this->client->createAuthUrl();
    }

    public function checkRedirectCode() {
        if (isset($_GET['code'])) {
            $token = $this->client->fetchAccessTokenWithAuthCode($_GET['code']);
            $this->setToken($token);
            $email = $this->getPayload();
            return true;
        }
        return false;
    }

    public function setToken($token) {
        $_SESSION['access_token'] = $token;
        $this->client->setAccessToken($token);
    }

    public function getToken() {
        return $this->client->getAccessToken();
    }

    public function getPayload() {
        try {
            $dataEmail = $this->client->verifyIdToken();
            return $dataEmail;
        } catch (Exception $exc) {
            
        }
        return null;
    }

}
