<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of permisos
 *
 * @author root
 */
class PermisosControl extends Controlador {

    function inicio() {
        $App = Visitante::app();
        Vistas::mostrar("permisos", "inicio", array(
            'Motivos' => PermisosMotivos::todos(),
            'Politica' => Aplicaciones::politica($App->aplicacionID)
        ));
    }

    function datosColaborador() {
        $Colaborador = Colaboradores::porIdentificacion($this->identificacion);
        if (!is_null($Colaborador)) {
            echo RespuestasSistema::exito(array("Colaborador" => $Colaborador));
        } else {
            echo RespuestasSistema::fallo("No se encontró un colaborador con identificación [" . $this->identificacion . " ].");
        }
    }

    function registroPermiso() {
        $colaboradorID = Colaboradores::idcoaboradoresPorIdentificacion($this->cedulaEmpleado);
        $idPermiso = Permisos::registrarPermiso($colaboradorID, $this->motivoPermiso, $this->fechaInicioPermiso, $this->JustificacionPermiso);
        if (!is_null($idPermiso)) {
            $Permiso = Permisos::datosCompletos($idPermiso);
            $notificacion = $this->notificarSolicitudPermiso($Permiso);
            if ($notificacion === true) {
                echo RespuestasSistema::exito(array("IDPERMISO" => $idPermiso));
            } else {
                echo RespuestasSistema::alerta(
                        array("IDPERMISO" => $idPermiso), "Se registró el permiso, pero no se pudo enviar la notificación al correo electrónico. Contacte con su jefe inmediato o personal de talento humano.\r\n"
                        . $notificacion
                );
            }
        } else {
            echo RespuestasSistema::fallo("NO SE PUDO REGISTRAR EL PERMISO");
        }
    }

    function notificarSolicitudPermiso($Permiso) {
        //Probando
        $emailDestino = "jpllinas@ccsm.org.co";
        $nombreDestino = "Juan LLinas";
        $Notificado = false;
        $Mensaje = "";



        //Notiificando al JefeInmediato
//        $emailDestino = $Permiso->jefeInmediatoColaboradorEMAIL;
//        $nombreDestino = $Permiso->jefeInmediatoPersonaNOMBRES . " " . $Permiso->jefeInmediatoPersonaAPELLIDOS;
        $mensaje = Permisos::correoAutorizacion($Permiso, $Permiso->colaboradorJEFEINMEDIATO, $emailDestino, $nombreDestino);
        $NotificadoJefe = Correos::enviar(
                        'PRUEBA APP PERMISOS:Tiene una nueva Solicitud de Permiso pendiente por AUTORIZAR.', $emailDestino, $nombreDestino, $mensaje
        );
        if (!$NotificadoJefe) {
            $Mensaje .= 'No se pudo enviar el correo de notificación al Jefe Inmediato';
        }

        //Enviar Copia de Autorizacion
        $ColaboradorCopia = Parametros::valor('COLABORADORCOPIAPERMISOS');
////        $emailDestino = $ColaboradorCopia->colaboradorEMAIL;
////        $nombreDestino = $ColaboradorCopia->personaNOMBRES . " " . $ColaboradorCopia->personaAPELLIDOS;
        $mensaje = Permisos::correoAutorizacion($Permiso, $ColaboradorCopia->colaboradorID, $emailDestino, $nombreDestino);
        $NotificadoCopia = Correos::enviar(
                        'PRUEBA APP PERMISOS: COPIA: Solicitud de Permiso pendiente por AUTORIZAR.', $emailDestino, $nombreDestino, $mensaje
        );
        if (!$NotificadoCopia) {
            $Mensaje .= 'No se pudo enviar la copia del correo de notificación a Talento Humano.';
        }

//        $emailDestino = $Permiso->colaboradorEMAIL;
//        $nombreDestino = $Permiso->personaNOMBRES . " " . $Permiso->personaAPELLIDOS;
        $mensaje = Permisos::correoSolicitud($Permiso);
        $NotificadoColaborador = Correos::enviar(
                        'PRUEBA APP PERMISOS: Se ha regitrado una nueva Solicitud de Permiso.', $emailDestino, $nombreDestino, $mensaje
        );
        if (!$NotificadoColaborador) {
            $Mensaje .= 'No se pudo enviar el correo de soporte de la solictud de permisos.';
        }

        if ($NotificadoJefe and $NotificadoCopia and $NotificadoColaborador) {
            $Notificado = true;
        } else {
            return $Mensaje;
        }
        return $Notificado;
    }

    function confirmarPermiso() {
        $permiso = Permisos::datosCompletos($this->idPermiso);
        Vistas::mostrar("permisos", "respuesta", array('Permiso' => $permiso));
    }

    //autorixzacion
    function autorizar() {
        $this->colaboradorID = $this->datos[0];
        $this->permisoID = $this->datos[1];
        $this->confirmarAutorizacion();
    }

    function noAutorizar() {
        $this->colaboradorID = $this->datos[0];
        $this->permisoID = $this->datos[1];
        $this->confirmarAutorizacion();
    }

    function confirmarAutorizacion() {
        $Permiso = Permisos::datosCompletos($this->permisoID);
        if ($Permiso) {
            $this->validarEstado($Permiso, 'autorizacion');
        } else {
            Vistas::mostrar("permisos", "error", array());
        }
    }

    function autorizacion() {
        Permisos::autorizacion($this->colaboradorID, $this->permisoID, Permisos::AUTORIZADO);
        $Permiso = Permisos::datosCompletos($this->permisoID);
        $this->notificarAutorizacion($Permiso);
        Vistas::mostrar("permisos", "fin-proceso", array('Permiso' => $Permiso));
    }

    function noAutorizacion() {
        Permisos::autorizacion($this->colaboradorID, $this->permisoID, Permisos::NOAUTORIZADO);
        $Permiso = Permisos::datosCompletos($this->permisoID);
        $this->notificarAutorizacion($Permiso);
        Vistas::mostrar("permisos", "fin-proceso", array('Permiso' => $Permiso));
    }

    function notificarAutorizacion($Permiso) {
        $emailDestino = "jpllinas@ccsm.org.co"; //$Permiso->colaboradorEMAIL;
        $nombreDestino = $Permiso->personaNOMBRES . " " . $Permiso->personaAPELLIDOS;
        $mensaje = Permisos::correoRespuestaAutorizacion($Permiso);
        $Notificado = Correos::enviar(
                        'PRUEBA APP PERMISOS: Respuesta a tu solicitud de permiso del dia ' . $Permiso->permisoFCHSOLICITADO . '.', $emailDestino, $nombreDestino, $mensaje
        );
        if (!$Notificado) {
            return $Mensaje .= 'No se pudo enviar el correo de respuesta a la solicitud de permiso.';
        }
        return $Notificado;
    }

    //CAncelacion
    function cancelar() {
        $this->permisoID = $this->datos[0];
        $Permiso = Permisos::datosCompletos($this->permisoID);
        if ($Permiso) {
            if ($Permiso->permisoESTADO == Permisos::PENDIENTE or $Permiso->permisoESTADO == Permisos::AUTORIZADO):
                $fecha = new DateTime();
                $fecha =  $fecha->format('Y-m-d H:i:s');
                if ($Permiso->permisoFCHPERMISO < $fecha){
                    Vistas::mostrar(
                            "permisos", 'cerrar', array(
                        'Permiso' => $Permiso)
                    );
                }else{
                    Vistas::mostrar(
                            "permisos", 'cancelacion', array(
                        'Permiso' => $Permiso)
                    );
                    
                }
                    else:
                Vistas::mostrar(
                        "permisos", "fin-proceso", array(
                    'Permiso' => $Permiso)
                );
            endif;
        }else {
            Vistas::mostrar("permisos", "error", array());
        }
    }

    function cancelacion() {
        Permisos::cancelacion($this->permisoID);
        $permiso = Permisos::datosCompletos($this->permisoID);
        Vistas::mostrar("permisos", "fin-proceso", array('Permiso' => $permiso));
    }

    //Cerrado
    function cerrar() {
        $this->permisoID = $this->datos[0];
        $Permiso = Permisos::datosCompletos($this->permisoID);
        if ($Permiso) {
            if ($Permiso->permisoESTADO == Permisos::AUTORIZADO):
                Vistas::mostrar(
                        "permisos", 'cerrar', array(
                    'Permiso' => $Permiso)
                );
            else:
                Vistas::mostrar(
                        "permisos", "fin-proceso", array(
                    'Permiso' => $Permiso)
                );
            endif;
        }else {
            Vistas::mostrar("permisos", "error", array());
        }
    }

    function cerrado() {
        if (isset($this->justificacion)) {
            Permisos::nousar($this->permisoID, $this->justificacion);
        } else {
            Permisos::cerrar($this->permisoID);
        }
        $Permiso = Permisos::datosCompletos($this->permisoID);
        $this->notificarCerrado($Permiso);
        Vistas::mostrar(
                "permisos", "fin-proceso", array(
            'Permiso' => $Permiso)
        );
    }

    function notificarCerrado($Permiso) {
        //arma el correo que se le envia a quien autorizó
        $ColaboradorAutorizo = Colaboradores::porId($Permiso->colaboradorAUTORIZA);
        $emailDestino = "jpllinas@ccsm.org.co"; //$ColaboradorAutorizo->colaboradorEMAIL;
        $nombreDestino = $ColaboradorAutorizo->personaNOMBRES . " " . $ColaboradorAutorizo->personaAPELLIDOS;
        $mensaje = Permisos::correoCerrado($Permiso, $ColaboradorAutorizo->colaboradorID, $emailDestino, $nombreDestino);
        $Notificado = Correos::enviar(
                        'PRUEBA APP PERMISOS: Aviso de regreso de permiso del colaborador ' . $Permiso->personaNOMBRES . ' ' . $Permiso->personaAPELLIDOS . '.', $emailDestino, $nombreDestino, $mensaje
        );
        if (!$Notificado) {
            return $Mensaje .= 'No se pudo enviar la copia del correo de notificación a Talento Humano.';
        }
        return $Notificado;
    }

    private function validarEstado($Permiso, $vistaPendiente) {
        if ($Permiso->permisoESTADO == Permisos::PENDIENTE):
            Vistas::mostrar(
                    "permisos", $vistaPendiente, array(
                'Permiso' => $Permiso,
                'Colaborador' => $this->colaboradorID)
            );
        else:
            Vistas::mostrar(
                    "permisos", "fin-proceso", array(
                'Permiso' => $Permiso,
                'Colaborador' => $this->colaboradorID)
            );
        endif;
    }

}
