<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of asistencia
 *
 * @author root
 */
class AsistenciaControl extends Controlador {

    function inicio() {
        if (is_null(Visitante::datoSession("ASISTENCIA-SEDE"))) {
            Vistas::mostrar(
                    "asistencia", "inicio", array(
                "Sedes" => Sedes::todas()
                    )
            );
        } else {
            $this->sede = Visitante::datoSession("ASISTENCIA-SEDE");
            $this->webcam();
        }
    }

    function webcam() {
        Visitante::datoSession("ASISTENCIA-SEDE", $this->sede);
        Vistas::mostrar(
                "asistencia", "webcam", array(
                )
        );
    }

    function inactividad() {
        Vistas::mostrar("asistencia", "inactividad", array());
    }

    function sinpermisos() {
        Vistas::mostrar("asistencia", "sinpermisos", array('error' => $this->error));
    }

    function confirmarMarcacion() {
        Vistas::mostrar("asistencia", "respuesta", array('Asistencia' => Asistencias::datos($this->idAsistencia)));
    }

    function controlTiempoMarcacion() {
        echo json_encode(array("tiempo" => getdate()));
    }

    function controlIpMarcacion() {
        echo json_encode(array("ipVisitante" => Visitante::ip()));
    }

    function datosColaborador() {
        echo json_encode(
                array("Colaborador" => Colaboradores::coaboradoresPorIdentificacion($this->identificacion))
        );
    }

    function registroTiempoMarcacion() {
        $img = $this->imgData;
        $nombreArchivo = $this->num_cedula . "-" . date('Ymdhis') . "";
        $carpetaArchivo = APPS_DIR . Parametros::valor('DIRFOTOSASISTENCIA') . date('Ymd') . DS;  //implement this function yourself
        $dirFoto = RecibirArchivos::imagenBase64($img, $nombreArchivo, $carpetaArchivo);
        $urlFoto = str_replace(APPS_DIR, APPS_WEB, $dirFoto);
        $colaboradorID = Colaboradores::idcoaboradoresPorIdentificacion($this->num_cedula);
        $sede = Visitante::datoSession('ASISTENCIA-SEDE');        
        $Jornada = Asistencias::jornadaTiempoAsistenciaColaborador($this->tiempo, $this->sentido, $colaboradorID);
        if( $Jornada['MEDIDA'] >= $Jornada['LIMITE'] and $this->sentido == Asistencias::ENTRADA ){
           echo json_encode(
                    array(
                        "RESPUESTA" => "FALLO",
                        "MENSAJE" => "NO SE PUEDE REGISTRAR UNA HORA DE ENTRADA DESPUES DE LA HORA SALIDA DE LA JORNADA. VERIFIQUE EL SENTIDO DE LA MARCACION."
                    )
            ); 
            exit();
        }
        $horario = NULL; //Asistencias::HorarioPorJornada($jornada);
        $idAsistencia = Asistencias::registrarTiempoAsistencia(
                        $colaboradorID, $sede, $Jornada['JORNADA'], $horario, $this->sentido, $this->carnet, $this->longitud, $this->latitud, $urlFoto, Visitante::ip()
        );
        if (!is_null($idAsistencia)) {
            echo json_encode(
                    array(
                        "RESPUESTA" => "EXITO",
                        "IDASISTENCIA" => $idAsistencia
                    )
            );
        } else {
            echo json_encode(
                    array(
                        "RESPUESTA" => "FALLO",
                        "MENSAJE" => "NO SE PUEDO REGISTRAR LA HORA DE ASISTENCIA."
                    )
            );
        }
    }

}
