<?php

/*
 * Copyright 2017-08-02  Cámara de Comercio de Santa Marta para el Magdalena.
 * Autor: Juan Pablo Llinás Ramírez <www.ccsm.org.co>.
 * Archivo: apps. 
 *
 * Licenciado bajo la Licencia Apache, Versión 2.0;
 * Usted no puede usar este archivo excepto en conformidad con la Licencia. 
 * Usted puede obtener una copia de la Licencia en 
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * A menos que sea requerido por la ley aplicable o acordado por escrito, el software
 * Distribuido bajo la licencia se distribuye en una "AS IS" o  "COMO ESTA" BASE,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, expresas o implícitas.
 * Consulte la Licencia para los permisos y Limitaciones bajo la Licencia.
 */

Class AppsControl extends Controlador {

    function inicio() {
        $aplicaciones = Aplicaciones::todas(Aplicaciones::PRODUCCION); //Aplicaciones::PRODUCCION);
        $categorias = Aplicaciones::getAllAplicacionesCategorias();
        Vistas::mostrar("tienda", "inicio", array('aplicaciones' => $aplicaciones, 'categorias' => $categorias));
    }

    function app() {
        $datos = Aplicaciones::getAplicacionByID($this->id);
        switch ($datos->aplicacionTipoCODIGO) {
//            case 'INTERNAS':
//                $abrirComo = "popUp('$datos->aplicacionURL', '$datos->aplicacionCODIGO');";
//                break;
            default:
                $abrirComo = "window.open('$datos->aplicacionURL', '_blank');";
                break;
        }
        $datos->abrir = $abrirComo;
        Vistas::mostrar("tienda", "app", array('datos' => $datos));
    }

    function abrir() {
        $App = Aplicaciones::porURL("/" . $this->app);
        Visitante::app($App);
        Vistas::mostrar(
                "tienda", "abrir", array(
            'App' => $App
                )
        );
    }

    function botonLogin() {
        Vistas::mostrar("tienda", "btn-google");
    }

    function cerrarSesion() {
        session_start();
        session_destroy();
        session_write_close();
    }

    function enviarMensaje() {
        $notificacion = $this->notificarMensaje($this->nombre, $this->email, $this->mensaje);
    }

    function notificarMensaje($nombre, $email, $mensaje) {
        //Probando
        $emailDestino = "soporte.tics@ccsm.org.co";
        $nombreDestino = "Centro de Servicio TICS";
        $Mensaje = "";
        
        $mensaje = Aplicaciones::correoContacto($emailDestino,$nombreDestino,$nombre, $email, $mensaje);
        $Notificado = Correos::enviar(
                        'Tiene una nuevo mensaje de la TIENDA DE APLICACIONES pendiente por revisar.', $emailDestino, $nombreDestino, $mensaje
        );
        if (!$Notificado) {
            $Mensaje .= 'No se pudo enviar el correo al centro TICS';
        }
    }
}
    