<?php



/*

 * To change this license header, choose License Headers in Project Properties.

 * To change this template file, choose Tools | Templates

 * and open the template in the editor.

 */



/**

 * Description of GoogleAuth

 *

 * @author Desarrollo

 */

class GoogleAuth {



    protected $client;



    public function __construct(Google_Client $googleClient = null) {

        $this->client = $googleClient;

        $secretAuth = Parametros::getValorPorCodigo('SECRETAUTH');

        $ClientId = Parametros::getValorPorCodigo('IDTAUTH');

        $RedirectUri = Parametros::getValorPorCodigo('URLREDIRECTAUTH');



        if ($this->client) {

            $this->client->setClientId($ClientId);

            $this->client->setClientSecret($secretAuth);

            $this->client->setRedirectUri($RedirectUri);

            $this->client->setScopes('email');

        }

    }



    public function isLogedIn() {

        return isset($_SESSION['access_token']);

    }



    public function getAuthUrl() {

        return $this->client->createAuthUrl();

    }



    public function checkRedirectCode() {

        if (isset($_GET['code'])) {

            $token = $this->client->fetchAccessTokenWithAuthCode($_GET['code']);

            $this->setToken($token);

            $email = $this->getPayload();

            return true;

        }

        return false;

    }



    public function setToken($token) {

        $_SESSION['access_token'] = $token;

        $this->client->setAccessToken($token);

    }



    public function getToken() {

        return $this->client->getAccessToken();

    }



    public function getPayload() {

        try {

            $dataEmail = $this->client->verifyIdToken();

            return $dataEmail;

        } catch (Exception $exc) {            

        }

        return null;

    }



}

