<!DOCTYPE html>
<html lang="es">

    <head>

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="">
        <meta name="author" content="">

        <title>Archivos de Pruebas</title>

        <!-- Bootstrap core CSS -->  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
        <link rel="stylesheet" href="vendor/zTree_v3-master/css/zTreeStyle/zTreeStyle.css" type="text/css">	


        <style type="text/css" media="screen">
            body {

            }

            #editor {
                margin: 0;
                top: 0;
                bottom: 0;
                left: 0;
                right: 0;
                position: relative;
                width: 100%;
                height: 600px;
            }

            #barraizq {
                width: auto;
                overflow-y: scroll;
                top: 0;
                bottom: 0;
                height: 560px;
            }

            #iframePage {
                width:100%;
                height:600px;
                border:dotted 1px red
            }
        </style>

        <style>
            /* Estilos para el menú contextual */
            #contextMenu {
                position: absolute;
                display: none;
                background: white;
                border: 1px solid #ccc;
                box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.2);
                padding: 5px;
                z-index: 1000;
            }
            #contextMenu ul {
                list-style: none;
                margin: 0;
                padding: 0;
            }
            #contextMenu ul li {
                padding: 8px 12px;
                cursor: pointer;
            }
            #contextMenu ul li:hover {
                background-color: #f0f0f0;
            }
        </style>

    </head>

    <body>

        <!-- Page Content -->
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <h1 class="mt-5">Archivos con Pruebas de Codigos o Funciones para el SICAM32</h1>
                </div>
            </div>
        </div>


        <div class="container">
            <div class="row">
                <div id="" class="col-md-4 ">
                    <h2 class="lead">Lista de Archivos</h2>
                    <div id="barraizq" >
                        <div class="zTreeDemoBackground left">
                            <ul id="treeDemo" class="ztree"></ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-8" style="text-align: center;">
                    <a id="enlaceNuevaVentana" href="#" target="_blank" >abrir en ventana nueva <span id="enlaceNuevaVentanaURL"></span></a>
                    <hr />
                    <iframe id="iframePage" src="vacio.html"  style="" frameborder="1"></iframe>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-12" >                    
                    <pre id="editor"><<-----   click en un archivo para ejecutar la pruea y ver el codigo</pre>
                </div>
            </div>
        </div>


        <!-- Menú contextual -->
        <div id="contextMenu">
            <ul>
                <li id="openLink">Abrir en nueva pestaña</li>
            </ul>
        </div>




        <script src="vendor/zTree_v3-master/js/jquery-1.4.4.min.js"></script> 
        <script type="text/javascript" src="vendor/zTree_v3-master/js/jquery.ztree.core.js"></script>
        <!--  <script type="text/javascript" src="vendor/zTree_v3-master/js/jquery.ztree.excheck.js"></script>
          <script type="text/javascript" src="vendor/zTree_v3-master/js/jquery.ztree.exedit.js"></script>-->
        <!-- Bootstrap core JavaScript -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>
        <script type="text/javascript">


            function showContextMenu(x, y) {
                $("#contextMenu").css({
                    top: y + "px",
                    left: x + "px"
                }).fadeIn();
            }

            function hideContextMenu() {
                $("#contextMenu").fadeOut();
            }

            var selectedNode = null; // Variable para guardar el nodo seleccionado

            var setting = {
                view: {
                    dblClickExpand: false,
                    showLine: true,
                    selectedMulti: false
                },
                callback: {

//                    onClick: function (event, treeId, treeNode) {
//                        if (treeNode.name) {
//                            let url = 'https://pruebas.sicam32.net/' + treeNode.carpeta + '/' + treeNode.name;
//                            window.open(url, '_blank'); // Abre en una nueva pestaña
//                        }
//                    },

                    onRightClick: function (event, treeId, treeNode) {
                        console.log(treeNode);
                        selectedNode = treeNode; // Guarda el nodo actual
                        showContextMenu(event.pageX, event.pageY); // Muestra el menú contextual
                    },

                    beforeClick: function (treeId, treeNode) {
                        var zTree = $.fn.zTree.getZTreeObj("tree");
                        if (treeNode.isParent) {
                            zTree.expandNode(treeNode);
                            return false;
                        } else {

                            $.ajax({
                                url: 'https://pruebas.sicam32.net/lector.php?ruta=' + treeNode.carpeta + '/' + treeNode.name,
                                type: 'GET',
                                success: function (data) {
                                    editor.setValue("");
                                    editor.session.setMode("ace/mode/php");
                                    editor.insert(data);
                                }
                            });
                            $("#iframePage").attr('src', 'https://pruebas.sicam32.net/' + treeNode.carpeta + '/' + treeNode.name);
                            $("#enlaceNuevaVentana").attr('href', 'https://pruebas.sicam32.net/' + treeNode.carpeta + '/' + treeNode.name);
                            $("#enlaceNuevaVentanaURL").html('https://pruebas.sicam32.net/' + treeNode.carpeta + '/' + treeNode.name);
                            return true;
                        }
                    }
                },

            };

            var zNodes = [
<?php imprimirEstructuraArchivos($directorio = 'codigos'); ?>
            ];
            $(document).ready(function () {
                $.fn.zTree.init($("#treeDemo"), setting, zNodes);

                // Evento para abrir enlace cuando se selecciona en el menú
                $("#openLink").click(function () {
                    if (selectedNode) {
                         let url = 'https://pruebas.sicam32.net/' + selectedNode.carpeta + '/' + selectedNode.name;
                          window.open(url, '_blank'); // Abre en una nueva pestaña
                    }
                    hideContextMenu();
                });

                // Ocultar menú si se hace clic fuera
                $(document).click(function () {
                    hideContextMenu();
                });

            });

        </script>
        <script src="vendor/ace-builds/src-noconflict/ace.js" type="text/javascript" charset="utf-8"></script>
        <script>
            var editor = ace.edit("editor");
            editor.setTheme("ace/theme/twilight");
            editor.session.setMode("ace/mode/javascript");
        </script>
    </body>

</html>
<?php
function imprimirEstructuraArchivos($directorio) {
    $carpeta = __DIR__ . DIRECTORY_SEPARATOR . $directorio;
    $archivos = scandir($carpeta);
    foreach ($archivos as $key => $archivo) {
        if ($archivo != "." && $archivo != "..") {
            if (is_dir($carpeta . DIRECTORY_SEPARATOR . $archivo)) {
                ?>
                {name: "<?= $archivo ?>", children: [
                <?php imprimirEstructuraArchivos($directorio . DIRECTORY_SEPARATOR . $archivo); ?>
                ]},
                <?php
            } else {
                ?>
                {name: "<?= $archivo ?>", carpeta: "<?= $directorio ?>"  },
                <?php
            }
        }
    }
}
?>