
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Ausentismos</title>
  <link href="https://fonts.googleapis.com/css?family=Karla:400,700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.materialdesignicons.com/4.8.95/css/materialdesignicons.min.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/bd-wizard.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.3.7/jquery.datetimepicker.min.css"/>
</head>
<body>
  <main class="d-flex min-vh-100">
      <div class="card bd-wizard-card">
          <div class="card-body">
            <div id="wizard">
                <h3>
                  <div class="media">
                    <div class="bd-wizard-step-icon">
                      <i class="mdi mdi-monitor-dashboard"></i>
                    </div>
                    <div class="media-body">
                      <h5 class="bd-wizard-step-title">Identificación</h5>
                      <p class="bd-wizard-step-subtitle">Tus datos de colaborador</p>
                    </div>
                  </div>
                </h3>
                <section>
                  <div class="brand-wrapper">
                    <h3><b>Nueva solicitud</b></h3>
                    <!-- <img src="assets/images/logo.svg" alt="logo" class="logo"> -->
                  </div>
                  <div class="row">
                    <div class="col-xl-6">
                      <h5 class="section-heading">Valida tus datos mediante tu cédula</h5>
                      <div class="form-group">
                          <label for="cedulaEmpleado">Tu Cédula</label>
                          <div class="input-group">
                              <input type="number" class="form-control cedulaEmpleado" name="cedulaEmpleado" id="cedulaEmpleado" placeholder="Cédula" required="">
                              <span class="input-group-btn d-flex align-items-center">
                                  <button class="btn btn-default h-100" id="btnCedulaEmpleado" type="button"><span class="bi bi-search" aria-hidden="true"></span></button>
                              </span> 
                          </div>
                      </div>
                      <div class="form-group">
                          <label for="nombreEmpleado">Tu Nombre</label>
                          <input type="text" class="form-control datosColaborador" id="nombreEmpleado" name="nombreEmpleado" placeholder="Nombre del Colaborador" disabled>
                      </div>
                      <div class="form-group">
                          <label for="jefeNombreEmpleado">Jefe Inmediato</label>
                          <input type="text" class="form-control datosColaborador" id="jefeNombreEmpleado" name="jefeNombreEmpleado" placeholder="Jefe inmediato" disabled>
                      </div>
                      <button class="bd-wizard-btn" data-step="next">Continuar</button>
                    </div>
                    <div class="col-xl-6 d-none d-xl-block">
                      <img src="assets/images/applicatin.jpg" alt="applicatin" class="img-fluid">
                    </div>
                  </div>
                  <!-- <p class="card-footer-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip </p> -->
                </section>
                <h3>
                  <div class="media">
                    <div class="bd-wizard-step-icon">
                      <i class="mdi mdi-briefcase"></i>
                    </div>
                    <div class="media-body">
                      <h5 class="bd-wizard-step-title">Datos de solicitud</h5>
                      <p class="bd-wizard-step-subtitle">Datos básicos de la solicitud</p>
                    </div>
                  </div>
                </h3>
                <section>
                  <div class="brand-wrapper">
                    <h3><b>Nueva solicitud</b></h3>
                    <!-- <img src="assets/images/logo.svg" alt="logo" class="logo"> -->
                  </div>
                  <h5 class="section-heading">Ingresa los datos básicos</h5>
                  <div class="form-group">
                      <label for="motivoPermiso">Tipo</label>
                      <div class="row mx-0">
                          <div class="form-check col-6">
                              <input class="form-check-input" type="radio" name="tipoPermiso" id="tipoPermiso1" checked value="1">
                              <label class="form-check-label" for="tipoPermiso1">Licencia laboral</label>
                          </div>
                          <div class="form-check col-6">
                              <input class="form-check-input" type="radio" name="tipoPermiso" id="tipoPermiso2" value="2">
                              <label class="form-check-label" for="tipoPermiso2">Permiso laboral</label>
                          </div>
                      </div>
                  </div>
                  <div class="form-group">
                      <div class="input-append date form_datetime">
                          <label for="fechaIncio">Fecha y Hora de Inicio</label>
                          <input type="text" class="form-control form_datetime" name="fechaInicio" id="fechaInicio" placeholder="Fecha y Hora de Inicio" required>
                          <span class="add-on"><i class="icon-th"></i></span>
                      </div>
                  </div>
                  <div class="form-group tipo_permiso tipo_permiso_1">
                      <div class="input-append date form_datetime">
                          <label for="fechaFin">Fecha y Hora de Fin</label>
                          <input type="text" class="form-control form_datetime" name="fechaFin" id="fechaFin" placeholder="Fecha y Hora de Fin">
                          <span class="add-on"><i class="icon-th"></i></span>
                      </div>
                  </div>
                  <button class="bd-wizard-btn mr-3" data-step="previous">Volver</button>
                  <button class="bd-wizard-btn" data-step="next">Continuar</button>
                </section>
                <h3>
                  <div class="media">
                    <div class="bd-wizard-step-icon">
                      <i class="mdi mdi-comment-question"></i>
                    </div>
                    <div class="media-body">
                      <h5 class="bd-wizard-step-title">Detalles</h5>
                      <p class="bd-wizard-step-subtitle">Datos puntuales de la solicitud</p>
                    </div>
                  </div>
                </h3>
                <section>
                  <div class="brand-wrapper">
                    <h3><b>Nueva solicitud</b></h3>
                    <!-- <img src="assets/images/logo.svg" alt="logo" class="logo"> -->
                  </div>
                  <h5 class="section-heading">Brindanos más datos sobre la solicitud</h5>
                  <div class="form-group">
                      <label for="motivo">Causante del Permiso</label>
                      <select id="motivo" name="motivo" class="form-select" required>
                          <option value="">Seleccione una opción</option>
                          <option value="1" class="tipo_permiso tipo_permiso_1">Circunstancias personales</option>
                          <option value="2" class="tipo_permiso tipo_permiso_1">Incapacidad médica</option>
                          <option value="3" class="tipo_permiso tipo_permiso_1">Maternidad</option>
                          <option value="4" class="tipo_permiso tipo_permiso_1">Paternidad</option>
                          <option value="4" class="tipo_permiso tipo_permiso_2">Cita médica</option>
                          <option value="4" class="tipo_permiso tipo_permiso_2">Diligencia personal</option>
                      </select>
                  </div>
                  <div class="form-group incapacidad">
                    <label for="epsColaborador">EPS a la que pertenece</label>
                    <select id="epsColaborador" name="epsColaborador" class="form-select">
                        <option value="">Seleccione una opción</option>
                        <option value="1">E.P.S.  SANITAS S.A.</option>
                        <option value="2">EPS SERVICIO OCCIDENTAL DE SALUD S.A.</option>
                        <option value="3">NUEVA EPS S.A.</option>
                        <option value="3">SALUD TOTAL S.A.  E.P.S.</option>
                    </select>
                </div>
                  <div class="form-group">
                    <label for="descripcion">Descripción corta de la solicitud</label>
                    <textarea class="form-control" name="descripcion" id="descripcion" placeholder="Descripción corta de la solicitud" style="resize: none;"></textarea>
                  </div>
                  <div class="form-group tipo_permiso tipo_permiso_1">
                      <label for="soporte" class="form-label">Soporte de la solicitud</label>
                      <input class="form-control" type="file" id="soporte" name="soporte" style="padding: 6px 12px; min-height: auto;">
                  </div>
                  <button class="bd-wizard-btn mr-3 mb-3 mb-sm-0" data-step="previous">Volver</button> <button class="bd-wizard-btn" data-step="next">Continuar</button>
                </section>
                <h3>
                  <div class="media">
                    <div class="bd-wizard-step-icon">
                      <i class="mdi mdi-shield-check"></i>
                    </div>
                    <div class="media-body">
                      <h5 class="bd-wizard-step-title">Terminos y condiciones</h5>
                      <!-- <p class="bd-wizard-step-subtitle">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. -->
                      <!--</p>-->
                    </div>
                  </div>
                </h3>
                <section>
                    <div class="brand-wrapper">
                        <h3><b>Nueva solicitud</b></h3>
                        <!--<img src="assets/images/logo.svg" alt="logo" class="logo">-->
                      </div>
                      <div class="overflow-auto" style="max-height: 60vh; padding-right: 4px">
                        <h2 style="text-align: center;">Politicas, Terminos y Condiciones de Uso de la &nbsp;Aplicación de Permisos</h2>
                        <h3 style="text-align: justify;">Debes tener en cuenta lo siguiente:</h3>
                        <p style="text-align: justify;">Esta aplicación solo esta habilitada para <strong>solicitar permisos</strong> para concurrencia al <strong>servicio médico</strong>&nbsp;y para <strong>diligencias personales</strong>, y que estas solicitudes están<strong> sujetas ha autorización por parte del Jefe Inmediato</strong> o del Encargado de la División de Talento Humano.</p>
                        <p style="text-align: justify;"><strong>Estos permisos no pueden ser superiores a un dia de trabajo</strong>. Es decir, que todos los permisos autorizados, solo son validos para el dia en que se solicitó, por lo que debe ser cerrado el mismo dia. Asi, si el permiso es de varios dias, debe solicitarlo de manera escrita.</p>
                        <h4 style="text-align: justify;">Como funciona</h4>
                        <p>Esta aplicación permite diligenciar un formulario con los datos necesarios para la solicitudes de permisos hasta un dia, para los colaboradores de la Cámara de Comercio de Santa Marta para el Magdalena.&nbsp;</p>
                        <p>Una vez diligenciado los datos, y que estos sean validos, deberá presionar el botón Realizar Solicitud para que el sistema registre los datos del permiso y envie las notificaciones electronicas correspondientes. Estas notificaciones serán enviadas a su jefe inmediato, al encargado de talento humano y a usted. Estas notificaciones pueden ser recibidas como avisos dentro del sistema y como correos electronicos.</p>
                        <p><strong>Al jefe inmediato</strong> y al encargado de talendo humano<strong> se les envia un correo</strong> con los datos de la solicitud y <strong>con enlaces para autorizar o no autorizar</strong> el permiso, y<strong> a usted se le envia un correo de confirmación</strong> de los solciitud registrada y <strong>con un enlace para cancelar el permiso</strong>.</p>
                        <h4>Autorización de un permiso</h4>
                        <p>El<strong> jefe inmediato debe</strong> ingresar al sistema y <strong>responder el aviso sobre el permiso, o utilizar el enlace recibido por correo electrónico, bien sea para autorizar o no autorizar el permiso.</strong> Luego de esto, el sistema le notificará la respuesta del Jefe inmediato.</p>
                        <p><em><strong>En caso de que el jefe inmediato no pueda responder la solicitud, usted está en la obligación de contactar al encargado de talento humano para que responda su solicitud.</strong></em></p>
                        <h4 style="text-align: justify;">Cancelar un permiso</h4>
                        <p style="text-align: justify;">Usted puede cancelar un permiso <strong>antes de que inicie el tiempo autorizado para el permiso</strong>. Luego de que pase la fecha y hora autorizada para el permiso, usted solo podrá cerrarlo. Si <strong>el permiso no fue autorizado, el sistema lo cancelará automaticamente</strong>.</p>
                        <p style="text-align: justify;"><em><strong>Si pasó el tiempo del permiso autorizado&nbsp;y no lo usó, tambien debe cerrarlo pero indicar que no lo uso y escribir la razón del porque no lo usó.</strong></em></p>
                        <h4 style="text-align: justify;">Avisar que regresó</h4>
                        <p style="text-align: justify;">Si se ha autorizado el permiso,<strong> usted tiene la obligación de notificar cuando haya regresado</strong> a sus labores y debe cerrar el permiso en el sistema. Para esto el sistema le envia junto <strong>con la confirmación de autorización, un enlace que le permitirá cerrar</strong> el permiso e indicarle al sistema que notifiqué al quien le autorizó el permiso, que ya regresó.</p>
                        <p style="text-align: justify;">En cualquier caso, el sistema verificará todos los dias los permisos autorizados del dia anterior y<strong> cerrará todos los permisos autorizados y no cerrados, indicando que usted no regresó del permiso, lo que afectará su indicador de AUSENTISMO LABORAL</strong>.</p>
                      </div>
                  <div class="form-check my-4">
                    <label class="form-check-label">
                      <input type="checkbox" class="form-check-input" name="termsAgreement" id="termsAgreement"
                        value="termsAgreed">
                      Acepto los términos y condiciones de uso
                    </label>
                  </div>
                  <button class="bd-wizard-btn mr-3" data-step="previous">Volver</button>
                  <button class="bd-wizard-btn" data-step="finish">Enviar solicitud</button>
                </section>
            </div>
          </div>
        </div>
  </main>
  <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"></script>
  <script src="assets/js/jquery.steps.min.js"></script>
  <script src="assets/js/bd-wizard.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.full.min.js" integrity="sha512-AIOTidJAcHBH2G/oZv9viEGXRqDNmfdPVPYOYKGy3fti0xIplnlgMHUGfuNRzC6FkzIo0iIxgFnr9RikFxK+sw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <script src="assets/js/main.js"></script>
</body>
</html>