<?php

require_once '../../conexion_sicam_produccion.php';

class ConversacionController {

    public function iniciarConversacion($tipo) {
        // Obtener el mensaje inicial según el tipo de conversación
        $mensajeInicial = RobotsMensajes::obtenerPorTipo($tipo);
        if (!$mensajeInicial) {
            return "No se encontró un flujo de conversación para este tipo.";
        }

        return $this->procesarMensaje($mensajeInicial);
    }

    private function procesarMensaje($mensaje) {
        $respuesta = [
            'mensaje' => $mensaje->texto,
            'opciones' => []
        ];

        // Obtener opciones de respuesta asociadas al mensaje
        $opciones = RobotsOpcionesRespuestas::obtenerPorMensaje($mensaje->id);
        foreach ($opciones as $opcion) {
            $respuesta['opciones'][] = [
                'id' => $opcion->robotOpcionRespuestaID,
                'titulo' => $opcion->robotOpcionRespuestaTITULO
            ];
        }

        // Agregar "Salir" como una opción general
        $respuesta['opciones'][] = ['id' => 'salir', 'titulo' => 'Salir'];

        return $respuesta;
    }

    public function seleccionarOpcion($opcionID) {
        if ($opcionID === 'salir') {
            return "Has salido de la conversación.";
        }

        $opcion = RobotsOpcionesRespuestas::obtenerPorID($opcionID);
        if (!$opcion) {
            return "Opción no válida.";
        }

        // Ejecutar acción asociada si existe
        $accion = RobotsAcciones::obtenerPorID($opcion->robotMensajeDESTINOID);
        if ($accion) {
            return $this->ejecutarAccion($accion);
        }

        // Obtener el siguiente mensaje si no hay acción
        $siguienteMensaje = RobotsMensajes::obtenerPorID($opcion->robotMensajeDESTINOID);
        return $siguienteMensaje ? $this->procesarMensaje($siguienteMensaje) : "Fin de la conversación.";
    }

    private function ejecutarAccion($accion) {
        // Aquí se ejecuta la acción según el tipo definido en la base de datos
        return "Ejecutando acción: " . $accion->robotAccionTITULO;
    }
}

$controller = new ConversacionController();
$tipoConversacion = readline("Seleccione el tipo de conversación (soporte, consultas, ventas): ");
$controller->iniciarConversacion($tipoConversacion);

while (true) {
    $mensajeActual = $controller->obtenerMensajeActual();

    echo "\n" . $mensajeActual->texto . "\n";

    if (!empty($mensajeActual->opciones)) {
        foreach ($mensajeActual->opciones as $indice => $opcion) {
            echo "[$indice] " . $opcion->titulo . "\n";
        }

        $seleccion = readline("Seleccione una opción: ");

        if (strtolower($seleccion) === "salir") {
            echo "Has salido de la conversación.\n";
            break;
        }

        if (isset($mensajeActual->opciones[$seleccion])) {
            $opcionSeleccionada = $mensajeActual->opciones[$seleccion];
            $controller->procesarOpcion($opcionSeleccionada);
        } else {
            echo "Opción no válida. Intente de nuevo.\n";
        }
    } else {
        echo "No hay más opciones disponibles. La conversación ha terminado.\n";
        break;
    }
}
