<?php

require_once '../../conexion_sicam_produccion.php';

// Obtener las conversaciones
$conversaciones = RobotsConversaciones::todos();

// Array para almacenar el árbol de decisiones
$arbolDecision = [];

foreach ($conversaciones as $Conversacion) {
    // Obtenemos los mensajes de cada conversación
    $mensajes = RobotsMensajes::porCodigoConversacion($Conversacion->robotConversacionCODIGO);

    // Inicializamos el nodo principal de la conversación
    $nodoConversacion = [
        'codigo' => $Conversacion->robotConversacionCODIGO,
        'nombre' => $Conversacion->robotConversacionTITULO, // o cualquier otro dato relevante
        'mensajes' => []
    ];

    // Iteramos sobre cada mensaje asociado a la conversación
    foreach ($mensajes as $Mensaje) {
        // Obtenemos las opciones del mensaje
        $Mensaje->opciones = RobotsOpcionesRespuestas::porCodigoMensaje($Mensaje->robotMensajeCODIGO);

        // Inicializamos la estructura del mensaje
        $nodoMensaje = [
            'codigo' => $Mensaje->robotMensajeCODIGO,
            'mensaje' => $Mensaje->robotMensajeTITULO,  // El texto del mensaje
            'opciones' => []
        ];

        // Si el mensaje tiene una acción asociada, la obtenemos
        if ($Mensaje->robotAccionID) {
            $nodoMensaje['accion'] = RobotsAcciones::datos($Mensaje->robotAccionID);
        }

        // Iteramos sobre las opciones del mensaje
        foreach ($Mensaje->opciones as $Opcion) {
            // Inicializamos la estructura de cada opción
            $nodoOpcion = [
                'codigo' => $Opcion->robotOpcionRespuestaCODIGO,
                'opcion' => $Opcion->robotOpcionRespuestaTITULO,  // El texto de la opción
                'accion' => null
            ];

            // Si la opción tiene una acción asociada, la obtenemos
            if ($Opcion->robotAccionID) {
                $nodoOpcion['accion'] = RobotsAcciones::datos($Opcion->robotAccionID);
            }
 
            // Agregamos la opción al mensaje
            $nodoMensaje['opciones'][] = $nodoOpcion;
        }

        // Agregamos el mensaje al nodo de la conversación
        $nodoConversacion['mensajes'][] = $nodoMensaje;
    }

    // Agregamos la conversación al árbol de decisiones
    $arbolDecision[] = $nodoConversacion;
}

// Codificar el árbol de decisiones en JSON
//echo json_encode($arbolDecision);

?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Árbol de Decisiones del Robot</title>

    <!-- Incluir la librería jsTree -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.12/themes/default/style.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.12/jstree.min.js"></script>

    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        #tree {
            margin-top: 20px;
            border: 1px solid #ccc;
            padding: 10px;
        }
        h1 {
            text-align: center;
        }
        .node-label {
            display: inline-block;
            padding: 5px;
            background-color: #f0f0f0;
            border-radius: 3px;
            margin-right: 5px;
        }
        .node-accion {
            font-size: 0.9em;
            color: #007bff;
        }
    </style>
</head>
<body>

    <h1>Árbol de Decisiones del Robot</h1>
    <div id="tree"></div>

    <script>
        // Datos de ejemplo generados desde PHP (aquí deberías insertar tu JSON generado desde PHP)
        const arbolDecision = <?php echo json_encode($arbolDecision); ?>;

        // Función para transformar el árbol de decisiones en formato compatible con jsTree
        function transformarArbol(arbol) {
            return arbol.map(conversacion => {
                return {
                    "text": conversacion.nombre,
                    "icon": "fa fa-folder", // Icono de carpeta para las conversaciones
                    "children": conversacion.mensajes.map(mensaje => {
                        return {
                            "text": `${mensaje.mensaje} ${mensaje.accion ? `<span class="node-accion">- Acción: ${mensaje.accion.descripcion}</span>` : ''}`,
                            "icon": "fa fa-comment-alt", // Icono de mensaje para los mensajes
                            "children": mensaje.opciones.map(opcion => {
                                let opcionTexto = opcion.opcion;
                                let accionTexto = opcion.accion ? `<span class="node-accion"> - Acción: ${opcion.accion.descripcion}</span>` : '';
                                return {
                                    "text": `${opcionTexto}${accionTexto}`,
                                    "icon": "fa fa-check-circle", // Icono de verificación para las opciones
                                    "state": {
                                        "opened": false
                                    }
                                };
                            })
                        };
                    })
                };
            });
        }

        // Inicializar el árbol con los datos transformados
        $(document).ready(function() {
            $('#tree').jstree({
                'core': {
                    'data': transformarArbol(arbolDecision),
                    'themes': {
                        'name': 'default',
                        'responsive': true
                    }
                },
                "plugins": ["types"]
            });
        });
    </script>

</body>
</html>
