<?php
require_once '../../conexion_sicam_produccion.php';

$Pqr = Pqrs::datosCompletos(158);
$rutaPlantilla = 'documentos/pqrs/constancia.html';

$documentoID = Documentos::guardarPorTipologia(TiposDocumentos::CONSTANCIAPETICIONVERBAL, "Constancia de petición verbal");
$Documento = Documentos::datosCompletos($documentoID);

$PeticionVerbalPDF = new PeticionVerbalPDF($Documento->documentoHASH);
$PeticionVerbalPDF->datosHeader($Documento->documentoCONSECUTIVO, $Pqr->Colaborador->sedeTITULO, $Documento->documentoFCHCREADO, $Pqr->AtencionPublico->canalAtencionTITULO);
$PeticionVerbalPDF->titulo = $Documento->documentoTITULO;
$PeticionVerbalPDF->asunto = $Documento->documentoTITULO . ' - ' . $Pqr->pqrCODIGO;
$PeticionVerbalPDF->rutaCertificado = $Documento->documentoDIR;
$PeticionVerbalPDF->autor = "[" . $Pqr->Colaborador->colaboradorIDENTIFICACION . "] " . $Pqr->Colaborador->colaboradorNOMBRECOMPLETO;

$documentoURL = $PeticionVerbalPDF->generar(['Pqr' => $Pqr, 'Documento' => $Documento], $rutaPlantilla);
Documentos::actualizarURL($Documento->documentoID, $documentoURL);
?>

<p><?= $documentoURL ?></p>
<iframe src="<?= $documentoURL ?>" style="height: 90vh; width: 90vw"></iframe>