{% extends "base.html.php" %}

{% block content %}
<!-- Hero Section -->
<section id="hero" class="hero section">
    <div class="hero-bg">
        <img src="assets/img/hero-bg-light.webp" alt="">
    </div>
    <div class="container text-center">
        <div class="d-flex flex-column justify-content-center align-items-center">
            <img src="https://img.tiendasicam32.net/masc/logomasc-2024.png" class="img-fluid hero-img" width="90%" alt="" data-aos="zoom-out" data-aos-delay="300">
            <!--         
          <h1 data-aos="fade-up" class="">Welcome to <span>QuickStart</span></h1>
          <p data-aos="fade-up" data-aos-delay="100" class="">Quickly start your project now and set the stage for success<br></p>
          <div class="d-flex" data-aos="fade-up" data-aos-delay="200">
            <a href="#about" class="btn-get-started">Get Started</a>
            <a href="https://www.youtube.com/watch?v=LXb3EKWsInQ" class="glightbox btn-watch-video d-flex align-items-center"><i class="bi bi-play-circle"></i><span>Watch Video</span></a>
          </div>
          <img src="assets/img/hero-services-img.webp" class="img-fluid hero-img" alt="" data-aos="zoom-out" data-aos-delay="300">
        -->
        </div>
        <div class="text-center mt-1" data-aos="fade-up" data-aos-delay="100">
            <h3>Seleccione el servicio que desea cotizar en el Centro de Arbitraje, Conciliación y Amigable Composición</h3>
        </div>
    </div>
</section><!-- /Hero Section -->

<!-- Featured Services Section -->
<section id="featured-services" class="featured-services section">

    <div class="container">

        <div class="row gy-4">
            <div class="col-xl-4 col-lg-6 servicio" data-aos="fade-up" data-aos-delay="100" data-bs-toggle="collapse" data-bs-target="#collapseConciliacion" aria-expanded="false" aria-controls="collapseConciliacion">
                <div class="service-item d-flex flex-column align-items-center">
                    <img src="https://s3.pagegear.co/425/81/imagenes-editor/2022/05/servicios.jpg" alt="" style="border-radius: 500px; width: 30%; height: auto;">
                    <div class="d-flex flex-column justify-content-center m-2">
                        <h4 class="title"><a href="#" class="stretched-link">Conciliación en derecho</a></h4>
                    </div>
                </div>
            </div>
            <!-- End Service Item -->

            <div class="col-xl-4 col-lg-6 servicio" data-aos="fade-up" data-aos-delay="100" data-bs-toggle="collapse" data-bs-target="#collapseArbitraje" aria-expanded="false" aria-controls="collapseArbitraje">
                <div class="service-item d-flex flex-column align-items-center">
                    <img src="https://s3.pagegear.co/425/81/imagenes-editor/2022/05/servicios.jpg" alt="" style="border-radius: 500px; width: 30%; height: auto;">
                    <div class="d-flex flex-column justify-content-center m-2">
                        <h4 class="title"><a href="#" class="stretched-link">Arbitraje</a></h4>
                    </div>
                </div>
            </div>
            <!-- End Service Item -->

            <div class="col-xl-4 col-lg-6 servicio" data-aos="fade-up" data-aos-delay="100">
                <div class="service-item d-flex flex-column align-items-center">
                    <img src="https://s3.pagegear.co/425/81/imagenes-editor/2022/05/servicios.jpg" alt="" style="border-radius: 500px; width: 30%; height: auto;">
                    <div class="d-flex flex-column justify-content-center m-2">
                        <h4 class="title"><a href="#" class="stretched-link">Amigable Composición</a></h4>
                    </div>
                </div>
            </div>
            <!-- End Service Item -->

            <div class="col-xl-4 col-lg-6 servicio" data-aos="fade-up" data-aos-delay="100">
                <div class="service-item d-flex flex-column align-items-center">
                    <img src="https://s3.pagegear.co/425/81/imagenes-editor/2022/05/servicios.jpg" alt="" style="border-radius: 500px; width: 30%; height: auto;">
                    <div class="d-flex flex-column justify-content-center m-2">
                        <h4 class="title"><a href="#" class="stretched-link">Insolvencia</a></h4>
                    </div>
                </div>
            </div>
            <!-- End Service Item -->

            <div class="col-xl-4 col-lg-6 servicio" data-aos="fade-up" data-aos-delay="100">
                <div class="service-item d-flex flex-column align-items-center">
                    <img src="https://s3.pagegear.co/425/81/imagenes-editor/2022/05/servicios.jpg" alt="" style="border-radius: 500px; width: 30%; height: auto;">
                    <div class="d-flex flex-column justify-content-center m-2">
                        <h4 class="title"><a href="#" class="stretched-link">Acuerdos de Apoyo</a></h4>
                    </div>
                </div>
            </div>
            <!-- End Service Item -->

            <div class="col-xl-4 col-lg-6 servicio" data-aos="fade-up" data-aos-delay="100">
                <div class="service-item d-flex flex-column align-items-center">
                    <img src="https://s3.pagegear.co/425/81/imagenes-editor/2022/05/servicios.jpg" alt="" style="border-radius: 500px; width: 30%; height: auto;">
                    <div class="d-flex flex-column justify-content-center m-2">
                        <h4 class="title"><a href="#" class="stretched-link">Ejecución de Garantias Mobiliarias</a></h4>
                    </div>
                </div>
            </div>
            <!-- End Service Item -->

        </div>

    </div>

</section><!-- /Featured Services Section -->

<section id="calculadoras" class="section">
  <div class="collapse" id="collapseConciliacion">
    {% include 'conciliacion.html.php' %}
  </div>
  <div class="collapse" id="collapseArbitraje">
    {% include 'arbitraje.html.php' %}
  </div>
</section>

<!-- About Section -->
<section id="about" class="about section">

    <div class="container">

        <div class="row gy-4">
            <div class="col-lg-12 content" data-aos="fade-up" data-aos-delay="100">
                <h3 class="text-center">Formación y Capacitación en Mecanismos Alternativos de Solución de Conflictos</h3>
            </div>

            <div class="col-lg-12 d-block" id="slide" data-aos="fade-up" data-aos-delay="200">
                {% for Evento in Eventos %}
                <a class="evento-ho" target="blank" href="{{Evento.url_evento_informacion}}">
                    <img src="{{Evento.img_evento_appmovil}}" alt="{{Evento.txt_evento_titulo}}">
                    <div class="data-evento">
                        <div class="fecha-evento">
                            <div>{{Evento.fecha_evento_inicio|date('d')}}</div>
                            <div>{{Evento.mes_nombre_evento_inicio}}
                            </div>
                        </div>
                        <div class="txt-evento">
                            <h2>{{Evento.txt_evento_titulo}}</h2>
                        </div>
                    </div>
                </a>
                {% endfor %}
            </div>

            <div class="col-12 d-flex justify-content-end gap-2">
                <span class="arrow-left slick-arrow"><i class="fa fa-angle-left"></i></span>
                <span class="arrow-right slick-arrow"><i class="fa fa-angle-right"></i></span>
            </div>
            
            <div class="col-lg-12 d-flex justify-content-center">
                <button class="btn btn-outline-primary">¿Necesitas una información especial para ti?<br>Aquí puedes solicitarla</button>
            </div>
        </div>
    </div>
</section><!-- /About Section -->

<!-- Contact Section -->
<section id="contact" class="contact section">

    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
        <h2>Contacto</h2>
    </div><!-- End Section Title -->

    <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row gy-4">

            <div class="col-lg-6">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="200">
                    <i class="bi bi-geo-alt"></i>
                    <h3>Dirección</h3>
                    <p>Cl. 24 #2-66, Comuna 2, Santa Marta, Magdalena</p>
                </div>
            </div><!-- End Info Item -->

            <div class="col-lg-3 col-md-6">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="300">
                    <i class="bi bi-telephone"></i>
                    <h3>Celular</h3>
                    <p>+57 3045627281</p>
                </div>
            </div><!-- End Info Item -->

            <div class="col-lg-3 col-md-6">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="400">
                    <i class="bi bi-envelope"></i>
                    <h3>Correo electrónico</h3>
                    <p>conciliacion@ccsm.org.co</p>
                </div>
            </div><!-- End Info Item -->

        </div>

        <div class="row gy-4 mt-1">
            <div class="col-lg-6" data-aos="fade-up" data-aos-delay="300">
                <iframe src="https://maps.google.com/maps?hl=en&amp;q=camara%20de%20comercio%20Santa%20marta+()&amp;t=&amp;z=15&amp;ie=UTF8&amp;iwloc=B&amp;output=embed" frameborder="0" style="border:0; width: 100%; height: 400px;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div><!-- End Google Maps -->

            <div class="col-lg-6">
                <form action="forms/contact.php" method="post" class="php-email-form" data-aos="fade-up" data-aos-delay="400">
                    <div class="row gy-4">

                        <div class="col-md-6">
                            <input type="text" name="name" class="form-control" placeholder="Nombre" required="">
                        </div>

                        <div class="col-md-6 ">
                            <input type="email" class="form-control" name="email" placeholder="Correo electrónico" required="">
                        </div>

                        <div class="col-md-12">
                            <input type="text" class="form-control" name="subject" placeholder="Asunto" required="">
                        </div>

                        <div class="col-md-12">
                            <textarea class="form-control" name="message" rows="6" placeholder="Mensaje" required=""></textarea>
                        </div>

                        <div class="col-md-12 text-center">
                            <!-- <div class="loading">Loading</div>
                  <div class="error-message"></div>
                  <div class="sent-message">Your message has been sent. Thank you!</div> -->

                            <button type="submit">Enviar mensaje</button>
                        </div>

                    </div>
                </form>
            </div><!-- End Contact Form -->

        </div>

    </div>

</section><!-- /Contact Section -->

{% endblock %}