<?php

require_once '../../conexion_sicam_produccion.php';

$Casos = EstudiosPrevios::todos();
//se hizo para casos despues del bloqueo del envio de correos
$CasosPendientes = array_filter($Casos, function ($Caso) {
    return $Caso->estudioPrevioFCHCREADO > '2025-03-13 13:30:00';
});

foreach ($CasosPendientes as $EstudioPrevio) {
    switch ($EstudioPrevio->estudioPrevioRESOLUCION) {
        case EstudiosPrevios::APROBADO:
            $Enviado = EstudiosPreviosNotificaciones::notificarEstudioPrevioAprobado($EstudioPrevio);
            break;
        case EstudiosPrevios::NO_APROBADO:
            $Enviado = EstudiosPreviosNotificaciones::notificarEstudioPrevioNoAprobado($EstudioPrevio);
            break;
        case EstudiosPrevios::PENDIENTE:
        default:
            $Enviado = EstudiosPreviosNotificaciones::notificarEstudioPrevioPendiente($EstudioPrevio);
    }
    
    print_r("Caso " . $EstudioPrevio->estudioPrevioCODIGO);
    print_r(PHP_EOL);
    print_r($Enviado);
    print_r(PHP_EOL);
    print_r(PHP_EOL);
    
    sleep(15);
}