<?php
 /*
  * Copyright 2017-09-08  Cámara de Comercio de Santa Marta para el Magdalena.
  * Autor: Juan Pablo Llinás Ramírez <jpllinas@ccsm.org.co at www.ccsm.org.co>.
  * Autor: Luis Montoya <lmontoya@ccsm.org.co at www.ccsm.org.co>.
  * Archivo: Colaboradores.
  *
  * Licenciado bajo la Licencia Apache, Versión 2.0;
  * Usted no puede usar este archivo excepto en conformidad con la Licencia.
  * Usted puede obtener una copia de la Licencia en
  *
  *   	http://www.apache.org/licenses/LICENSE-2.0
  *
  * A menos que sea requerido por la ley aplicable o acordado por escrito, el software
  * Distribuido bajo la licencia se distribuye en una "AS IS" o  "COMO ESTA" BASE,
  * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, expresas o implícitas.
  * Consulte la Licencia para los permisos y Limitaciones bajo la Licencia.
  */
 class _Colaboradores {
     const ACTIVO = 'ACTIVO';
     const DESACTIVO = 'DESACTIVO';
     const SUSPENDIDO = 'SUSPENDIDO';

     /**
      * Devuelve todos los registros de colaboradores, según el estado.
      * Si no se envia el estado devuelve todos los registros
      * sin importar su estado.
      *
      * @param string $colaboradorESTADO
      *
      * @return array de Objetos colaboradores
      */
     public static function todos($colaboradorESTADO = null) {
         $datos = array();
         $sqlQuery = ColaboradoresSQL::$sqlCompleto;
         if (!is_null($colaboradorESTADO)) {
             $sqlQuery .= ' WHERE CamaraColaboradores.colaboradorESTADO = ? ';
             array_push($datos, $colaboradorESTADO);
         }
         return SicamDB::selectVariasFilas($sqlQuery, $datos);
     }

     /**
      * Devuelve todos los registros de colaboradores, según el estado.
      * Si no se envia el estado devuelve todos los registros
      * sin importar su estado.
      *
      * @param string $colaboradorESTADO
      *
      * @return array de Objetos colaboradores
      */
     public static function todosSencillo($colaboradorESTADO = null) {
         $datos = array();
         $sqlQuery = ColaboradoresSQL::DATOS_BASICOS;
         if (!is_null($colaboradorESTADO)) {
             $sqlQuery .= ' WHERE CamaraColaboradores.colaboradorESTADO = ? ';
             array_push($datos, $colaboradorESTADO);
         }
         return SicamDB::selectVariasFilas($sqlQuery, $datos);
     }

     /**
      * Devuelve todos los registros de colaboradores, según el estado.
      * Si no se envia el estado devuelve todos los registros
      * sin importar su estado.
      *
      * @param string $colaboradorESTADO
      *
      * @return array de Objetos colaboradores
      */
     public static function todosCompleto($colaboradorESTADO = null) {
         $datos = array();
         $sqlQuery = ColaboradoresSQL::$sqlCompleto;
         if (!is_null($colaboradorESTADO)) {
             $sqlQuery .= ' WHERE CamaraColaboradores.colaboradorESTADO = ? ';
             array_push($datos, $colaboradorESTADO);
         }
         return SicamDB::selectVariasFilas($sqlQuery, $datos);
     }

     /**
      * Devuelve todos los registros de colaboradores, según el estado.
      * Si no se envia el estado devuelve todos los registros
      * sin importar su estado.
      *
      * @param string $colaboradorESTADO
      *
      * @return array de Objetos colaboradores
      */
     public static function porSedeUnidadCargo($sedeID = null, $unidadID = null, $cargoID = null, $colaboradorESTADO = 'ACTIVO') {
         $datos = array();
         $sqlQuery = ColaboradoresSQL::$sqlDatosColaborador;
         $sqlQuery .= ' WHERE CamaraColaboradores.personaID IS NOT NULL ';
         if (!is_null($sedeID)) {
             $sqlQuery .= ' AND CamaraSedes.sedeID = ? ';
             array_push($datos, $sedeID);
         }
         if (!is_null($unidadID)) {
             $sqlQuery .= ' AND ( CamaraUnidadesDivisiones.unidadID = ? OR CamaraUnidadesDivisiones.unidadPADRE = ?  ) ';
             array_push($datos, $unidadID);
             array_push($datos, $unidadID);
         }
         if (!is_null($cargoID)) {
             $sqlQuery .= ' AND CamaraCargos.cargoID = ? ';
             array_push($datos, $cargoID);
         }
         if (!is_null($colaboradorESTADO)) {
             $sqlQuery .= ' AND CamaraColaboradores.colaboradorESTADO = ? ';
             array_push($datos, $colaboradorESTADO);
         }
         // echo $sqlQuery;
         return SicamDB::selectVariasFilas($sqlQuery, $datos);
     }

     /**
      * Devuelve los registros de colaboradores en estado ACTIVO.
      *
      * @return array de Objetos colaboradores
      */
     public static function activos() {
         return self::todos(self::ACTIVO);
     }

     /**
      * Devuelve los registros de colaboradores en estado DESACTIVO.
      *
      * @return array de Objetos colaboradores
      */
     public static function desactivos() {
         return self::todos(self::DESACTIVO);
     }

     //put your code here
     public static function getColaboradoresPorSedes($idSede) {
         $sqlQuery = '
        SELECT Personas.personaNOMBRES,CamaraColaboradores.colaboradorID
        FROM SICAMDB.CamaraColaboradores 
        INNER JOIN SICAMDB.Personas ON CamaraColaboradores.personaID = Personas.personaID
        INNER JOIN MAESTRASDB.CamaraPuestosTrabajo ON CamaraColaboradores.puestoTrabajoID = CamaraPuestosTrabajo.puestoTrabajoID
        INNER JOIN MAESTRASDB.CamaraSedes ON CamaraPuestosTrabajo.sedeID = CamaraSedes.sedeID
        WHERE (CamaraPuestosTrabajo.sedeID = ?) AND ( CamaraColaboradores.colaboradorESTADO =  "ACTIVO")';
         return SicamDB::selectVariasFilas($sqlQuery, array(
               $idSede
         ));
     }

     public static function porIdUsuario($usuarioID) {
         $sqlQuery = ColaboradoresSQL::DATOS_COLABORADORES_USUARIO_PERSONA_CARGO_DIRECION_CORREO
             . ColaboradoresSQL::JOIN_COLABORADORES_USUARIO_PERSONA_CARGO_DIRECION_CORREO
             . ' WHERE Usuarios.usuarioID = ?; ';
         return SicamDB::selectUnaFila($sqlQuery, array(
               $usuarioID
         ));
     }

     public static function datosCompletosPorUsuario($usuarioID) {
         $sqlQuery = ColaboradoresSQL::$sqlCompleto
             . ColaboradoresSQL::$sqlCompletoJOIN
             . ' WHERE ( Usuarios.usuarioID = ? ); ';
         return SicamDB::selectUnaFila($sqlQuery, array(
               $usuarioID
         ));
     }

     public static function datosColaboradoresUsuarioPorIdUsuario($usuarioID) {
         $sqlQuery = ColaboradoresSQL::DATOS_COLABORADORES_USUARIO_PERSONA_CARGO_DIRECION_CORREO . ' WHERE ( Usuarios.usuarioID = ? ); ';
         return SicamDB::selectUnaFila($sqlQuery, array(
               $usuarioID
         ));
     }

     public static function porCedula($identificacion) {
         return self::porIdentificacion(TiposIdentificacion::CEDULA, $identificacion);
     }

     public static function porIdentificacion($tipoIdentificacion, $identificacion) {
         $sqlQuery = ColaboradoresSQL::DATOS_COLABORADORES_USUARIO_PERSONA_CARGO_DIRECION_CORREO . ColaboradoresSQL::JOIN_COLABORADORES_USUARIO_PERSONA_CARGO_DIRECION_CORREO . ' WHERE ( Personas.tipoIdentificacionID = ? AND Personas.personaIDENTIFICACION = ?  ); ';
         return SicamDB::selectUnaFila($sqlQuery, array(
               $tipoIdentificacion,
               $identificacion
         ));
     }

     public static function porNumeroIdentificacion($identificacion) {
         $sqlQuery = ColaboradoresSQL::$sqlDatosColaborador . ' WHERE ( Personas.personaIDENTIFICACION = ?  ); ';
         return SicamDB::selectUnaFila($sqlQuery, array(
               $identificacion
         ));
     }

     public static function porId($colaboradorID) {
         return self::datosCompletos($colaboradorID);
     }

     public static function datosCompletos($colaboradorID) {
         $sqlQuery = ColaboradoresSQL::$sqlCompleto . ' WHERE ( CamaraColaboradores.colaboradorID = ? ); ';
         return SicamDB::selectUnaFila($sqlQuery, array(
               $colaboradorID
         ));
     }

     public static function porCargo($cargoID) {
         $sqlQuery = ColaboradoresSQL::DATOS_COLABORADORES_USUARIO_PERSONA_CARGO
             . " WHERE CamaraCargos.cargoID = ? AND CamaraColaboradores.colaboradorESTADO = '" . self::ACTIVO . "' ";
         return SicamDB::selectUnaFila($sqlQuery, array(
               $cargoID
         ));
     }

     public static function enElCargo($cargoID) {
         $sqlQuery = ColaboradoresSQL::DATOS_COLABORADORES_USUARIO_PERSONA_CARGO
             . " WHERE CamaraCargos.cargoID = ? AND CamaraColaboradores.colaboradorESTADO = '" . self::ACTIVO . "' ";
         return SicamDB::selectVariasFilas($sqlQuery, array(
               $cargoID
         ));
     }
     /*
      * *
      * * */

     public static function datos($colaboradorID) {
         $sqlQuery = ColaboradoresSQL::DATOS_BASICOS . ' WHERE CamaraColaboradores.colaboradorID =  ? ; ';
         $colaborador = SicamDB::selectUnaFila($sqlQuery, array(
               $colaboradorID
         ));
         if (!empty($colaborador)):
             $colaborador->Persona = Personas::datos($colaborador->personaID);
             return $colaborador;
         endif;
         return null;
     }

     public static function numeroSinContratista($fecha = null) {
         $sqlQuery = ColaboradoresSQL::CANTIDAD_COLABORADORES_SIN_CONTRATISTAS;
         if (!empty($fecha)) {
             $sqlQuery .= ' AND CamaraColaboradores.colaboradorFCHACTIVO < ? ';
         }
         $numeroColaborador = SicamDB::selectUnaFila($sqlQuery, array(
               $fecha
         ));
         return $numeroColaborador->colaboraresNUMERO;
     }

     public static function datosCompletosConJefeInmediato($tipoIdentificacionID, $personaIDENTIFICACION, $colaboradorESTADO = null) {
         $datos = array();
         $sqlQuery = ColaboradoresSQL::DATOS_BASICOS_JEFE_INMEDIATO . " WHERE  Personas.tipoIdentificacionID = ?  AND Personas.personaIDENTIFICACION = ? ";
         array_push($datos, $tipoIdentificacionID, $personaIDENTIFICACION);
         if (!empty($colaboradorESTADO)) {
             $sqlQuery .= ' AND CamaraColaboradores.colaboradorESTADO = ? ';
             array_push($datos, $colaboradorESTADO);
         }
         return SicamDB::selectUnaFila($sqlQuery, $datos);
     }

     public static function todosConJefeInmediato($colaboradorESTADO = null) {
         $datos = array();
         $sqlQuery = ColaboradoresSQL::DATOS_BASICOS_JEFE_INMEDIATO;
         if (!empty($colaboradorESTADO)) {
             $sqlQuery .= ' WHERE CamaraColaboradores.colaboradorESTADO = ? ';
             array_push($datos, $colaboradorESTADO);
         }
         return SicamDB::selectVariasFilas($sqlQuery, $datos);
     }

     //
     //
     //
     //
     //
     //
     //
     //
     //
     //
     //
     //
     public static function guardar($cargoID, $personaID, $puestoTrabajoID, $tipoColaboradorID, $colaboradorEMAIL, $colaboradorESTADO, $colaboradorJefeInmediato, $colaboradorCONTROLASISTENCIA, $colaboradorEXTENSION) {
         $sqlQuery = 'INSERT INTO SICAMDB.CamaraColaboradores ( ' . ' cargoID, personaID, puestoTrabajoID, tipoColaboradorID, colaboradorEMAIL ,colaboradorESTADO, colaboradorCONTROLASISTENCIA, colaboradorEXTENSION, ' . ' colaboradorJEFEINMEDIATO, colaboradorUSRACTIVO ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ';
         return SicamDB::insertFila($sqlQuery, array(
               $cargoID,
               $personaID,
               $puestoTrabajoID,
               $tipoColaboradorID,
               $colaboradorEMAIL,
               $colaboradorESTADO,
               $colaboradorCONTROLASISTENCIA,
               $colaboradorEXTENSION,
               $colaboradorJefeInmediato,
               Cliente::usuarioID(),
         ));
     }

     public static function actualizar($colaboradorID, $cargoID, $puestoTrabajoID, $tipoColaboradorID, $colaboradorESTADO, $colaboradorJefeInmediato, $colaboradorCONTROLASISTENCIA, $colaboradorEXTENSION) {
         $sqlQuery = ColaboradoresSQL::ACTUALIZAR_REGISTRO;
         return SicamDB::actualizarFila($sqlQuery, array(
               $cargoID,
               $puestoTrabajoID,
               $tipoColaboradorID,
               $colaboradorESTADO,
               $colaboradorJefeInmediato,
               $colaboradorCONTROLASISTENCIA,
               $colaboradorEXTENSION,
               $colaboradorID,
         ));
     }

     public static function eliminar($colaboradorID) {
         $sqlQuery = 'DELETE FROM SICAMDB.CamaraColaboradores WHERE colaboradorID = ?;';
         return SicamDB::actualizarFila($sqlQuery, array(
               $colaboradorID
         ));
     }

     public static function actualizarTipoColaborador($tipoColaboradorID, $colaboradorID) {
         $sqlQuery = 'UPDATE SICAMDB.CamaraColaboradores SET tipoColaboradorID = ?	WHERE	colaboradorID = ? ;';
         return SicamDB::actualizarFila($sqlQuery, array(
               $tipoColaboradorID,
               $colaboradorID
         ));
     }

     public static function actualizarCargoColaborador($cargoID, $colaboradorID) {
         $sqlQuery = 'UPDATE SICAMDB.CamaraColaboradores SET cargoID = ?	WHERE	colaboradorID = ? ;';
         return SicamDB::actualizarFila($sqlQuery, array(
               $cargoID,
               $colaboradorID
         ));
     }

     public static function actualizarPuestoTrabajoColaborador($puestoTrabajoID, $colaboradorID) {
         $sqlQuery = 'UPDATE SICAMDB.CamaraColaboradores SET puestoTrabajoID = ?	WHERE	colaboradorID = ? ;';
         return SicamDB::actualizarFila($sqlQuery, array(
               $puestoTrabajoID,
               $colaboradorID
         ));
     }

     public static function actualizarJefeInmediato($jefeInmediato, $colaboradorID) {
         $sqlQuery = ColaboradoresSQL::ACTUALIZAR_JEFEINMEDIATO;
         return SicamDB::actualizarFila($sqlQuery, array(
               $jefeInmediato,
               $colaboradorID
         ));
     }

     public static function actualizarEstadoColaborador($estadoColaborador, $colaboradorID) {
         $sqlQuery = 'UPDATE SICAMDB.CamaraColaboradores SET colaboradorESTADO = ?	WHERE	colaboradorID = ? ;';
         return SicamDB::actualizarFila($sqlQuery, array(
               $estadoColaborador,
               $colaboradorID
         ));
     }

     public static function actualizarFOTO($urlFOTO, $colaboradorID) {
         $sqlQuery = ColaboradoresSQL::ACTUALIZAR_FOTO;
         return SicamDB::actualizarFila($sqlQuery, array(
               $urlFOTO,
               $colaboradorID
         ));
     }

     public static function actualizarFIRMA($urlFIRMA, $colaboradorID) {
         $sqlQuery = ColaboradoresSQL::ACTUALIZAR_FIRMA;
         return SicamDB::actualizarFila($sqlQuery, array(
               $urlFIRMA,
               $colaboradorID
         ));
     }
 } 