<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Módulo de Atención</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body { background-color: #f8f9fa; }
        .turno-actual { font-size: 2.5rem; font-weight: bold; color: #dc3545; }
        .turno-panel { padding: 20px; border-radius: 10px; background: white; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); }
        .acciones { text-align: center; }
        .lista-turnos { max-height: 300px; overflow-y: auto; }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h1 class="text-center text-primary">Módulo de Atención</h1>
        
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="turno-panel text-center">
                    <h2>Turno Actual</h2>
                    <p class="turno-actual" id="turnoActual">A001</p>
                    <h4>Próximo Turno</h4>
                    <p class="fs-4" id="proximoTurno">A002</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="turno-panel lista-turnos">
                    <h4>Lista de Espera</h4>
                    <ul class="list-group" id="listaTurnos">
                        <li class="list-group-item">A002</li>
                        <li class="list-group-item">A003</li>
                        <li class="list-group-item">A004</li>
                        <li class="list-group-item">A005</li>
                    </ul>
                </div>
            </div>
            <div class="col-md-3">
                <div class="turno-panel acciones">
                    <h4>Acciones</h4>
                    <button class="btn btn-primary w-100 my-2" id="llamarTurno">Llamar</button>
                    <button class="btn btn-success w-100 my-2" id="finalizarTurno">Finalizar</button>
                    <button class="btn btn-warning w-100 my-2" id="reprogramarTurno">Reprogramar</button>
                    <button class="btn btn-danger w-100 my-2" id="cancelarTurno">Cancelar</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $("#llamarTurno").click(function() {
                let turno = $("#proximoTurno").text();
                if (turno !== "-") {
                    $("#turnoActual").text(turno);
                    $("#listaTurnos li").first().remove();
                    let siguienteTurno = $("#listaTurnos li").first().text() || "-";
                    $("#proximoTurno").text(siguienteTurno);
                }
            });
        });
    </script>
</body>
</html>
