<?php

function limpiar($string) {
    $string = trim($string);
    $string = preg_replace('/\t+/', ' ', $string);
    $string = trim(preg_replace('/\s\s+/', ' ', $string));
    $string = trim(preg_replace('/\s+/', ' ', $string));
    $string = trim(preg_replace('/\r|\n/', ' ', $string));
    $string = str_replace(
            array('"', '\''), array('', ''), $string
    );
    $string = str_replace(
            array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'), array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'), $string
    );
    $string = str_replace(
            array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'), array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'), $string
    );
    $string = str_replace(
            array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'), array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'), $string
    );
    $string = str_replace(
            array('ó', 'ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'), array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'), $string
    );
    $string = str_replace(
            array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'), array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'), $string
    );
    $string = str_replace(
            array('ñ', 'Ñ', 'ç', 'Ç'), array('n', 'N', 'c', 'C',), $string
    );
    //Esta parte se encarga de eliminar cualquier caracter extraño
    $string = str_replace(
            array("\\", "¨", "º", "~",
        "#", "@", "|", "!", "\"",
        "·", "$", "%", "&", "/",
        "(", ")", "?", "'", "¡",
        "¿", "[", "^", "`", "]",
        "+", "}", "{", "¨", "´",
        ">", "< ", ";", ",", ":",
        "."), '', $string
    );
    $string = str_replace(array("- ", "-", " "), "_", $string);
    $string = preg_replace('/\&(.)[^;]*;/', '\\1', $string);
    $string = strtolower($string);
    return $string;
}

echo "leyendo linea del archivo enviado....\n\r";
$inicio = microtime(true);
echo "INICIO ...." . date('y-m-d') . " " . $inicio . " \n\r";
$archivoLectura = 'SII_HISTORICOS_BD_2023.csv';
$archivo = 'convertido_test.csv';
$fileEscritura = fopen($archivo, "a");
$file = fopen($archivoLectura, "r");
$separador = ';';
if (file_exists($archivoLectura)) {
    $numeroLinea = 1;
    while (!feof($file)) {
        $lineaLeida = fgets($file);
        $linea = trim($lineaLeida);

        $fila = explode($separador, $linea);
        foreach ($fila as $key => $dato) {
            $dato = limpiar($dato);
            $dato = nl2br($dato, true);
            $fila[$key] = '\'' . $dato . '\'';
        }
        $texto = implode($separador, $fila);
        fwrite($fileEscritura, "" . $texto . "" . PHP_EOL);
        if ($numeroLinea % 1000 == 0) {
            echo "termianda linea " . $numeroLinea . ".... " . (microtime(true) - $inicio) . ".... \n\r";
        }
        $numeroLinea++;
    }
}
fclose($file);
fclose($fileEscritura);

$final = microtime(true);
echo "FINAL ...." . date('y-m-d') . " " . $final . " \n\r";
echo "DIFERENCIA .... " . ($final - $inicio) . " \n\r";

