<?php
// Configuración de la conexión
$host = '34.31.26.106'; // Cambiar por tu host
$user = 'sicam32-sync-google'; // Cambiar por tu usuario
$password = 'Pan|iV8SfY`5llHU'; // Cambiar por tu contraseña
$dbname = 'SII_Confecamaras'; // Cambiar por tu base de datos
// Crear la conexión
$conn = new mysqli($host, $user, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Consulta a la vista
$sql = "SELECT * FROM ServiciosValorFijo";
$result = $conn->query($sql);

// Verificar si hay resultados
if ($result->num_rows > 0) {
    // Crear una estructura jerárquica
    $tree = [];
    while ($row = $result->fetch_assoc()) {
        $grupoCodigo = $row['grupoProdservCODIGO'];
        $grupoTitulo = $row['grupoProdservTITULO'];
        $portafolioCodigo = $row['portafolioClaseCODIGO'];
        $portafolioTitulo = $row['portafolioClaseTITULO'];

        // Organizar niveles
        if (!isset($tree[$grupoCodigo])) {
            $tree[$grupoCodigo] = [
                'titulo' => $grupoTitulo,
                'portafolios' => []
            ];
        }

        if (!isset($tree[$grupoCodigo]['portafolios'][$portafolioCodigo])) {
            $tree[$grupoCodigo]['portafolios'][$portafolioCodigo] = [
                'titulo' => $portafolioTitulo,
                'servicios' => []
            ];
        }

        $tree[$grupoCodigo]['portafolios'][$portafolioCodigo]['servicios'][] = [
            'destacados' => array_intersect_key($row, array_flip(['CODIGO_SERVICIO', 'NOMBRE_SERVICIO', 'PESOS_TARIFA'])),
            'otros' => array_diff_key($row, array_flip(['grupoProdservCODIGO', 'grupoProdservTITULO', 'portafolioClaseCODIGO', 'portafolioClaseTITULO', 'CODIGO_SERVICIO', 'NOMBRE_SERVICIO', 'PESOS_TARIFA']))
        ];
    }
    ?>
    <!DOCTYPE html>
    <html lang="es">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Servicios Jerárquicos</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    margin: 20px;
                }
                ul {
                    list-style-type: none;
                    padding-left: 20px;
                }
                li {
                    margin-bottom: 10px;
                }
                .nivel-0 {
                    font-size: 38px;
                    font-weight: bold;
                }
                .nivel-1 {
                    font-size: 34px;
                    font-weight: bold;
                }
                .nivel-2 {
                    font-size: 30px;
                    font-weight: bold;
                }
                .tabla-servicios {
                    width: 100%;
                    border-collapse: collapse;
                    margin-top: 10px;
                    margin-bottom: 20px;
                }
                .tabla-servicios th, .tabla-servicios td {
                    border: 1px solid #ddd;
                    padding: 8px;
                    text-align: left;
                }
                .tabla-servicios th {
                    background-color: #f4f4f4;
                }
                #menu-grupos {
                    position: sticky;
                    top: 0;
                    background: #f9f9f9;
                    padding: 10px;
                    border-bottom: 2px solid #ddd;
                    z-index: 1000;
                }
                #menu-grupos a {
                    margin-right: 15px;
                    text-decoration: none;
                    color: #007BFF;
                    font-weight: bold;
                }
                #menu-grupos a:hover {
                    text-decoration: underline;
                }
                #tabla-seleccionados {
                    position: sticky;
                    top: 50px;
                    background: #f9f9f9;
                    border: 1px solid #ddd;
                    padding: 10px;
                    margin-bottom: 20px;
                    z-index: 1000;
                }
                #tabla-seleccionados table {
                    width: 100%;
                    border-collapse: collapse;
                }
                #tabla-seleccionados th, #tabla-seleccionados td {
                    border: 1px solid #ddd;
                    padding: 8px;
                    text-align: left;
                }
            </style>
            <script>
                const serviciosSeleccionados = [];

                function agregarServicio(codigo, nombre, tarifa) {
                    // Verificar si ya está agregado
                    if (serviciosSeleccionados.some(servicio => servicio.codigo === codigo)) {
                        alert("Este servicio ya está seleccionado.");
                        return;
                    }

                    // Agregar el servicio al array
                    serviciosSeleccionados.push({codigo, nombre, tarifa});

                    // Actualizar la tabla
                    actualizarTabla();
                }

                function actualizarTabla() {
                    const tabla = document.getElementById("servicios-seleccionados");
                    let total = 0;

                    // Limpiar contenido actual
                    tabla.innerHTML = "";

                    // Generar nuevas filas
                    serviciosSeleccionados.forEach(servicio => {
                        total += parseFloat(servicio.tarifa);
                        tabla.innerHTML += `
                            <tr>
                                <td>${servicio.codigo}</td>
                                <td>${servicio.nombre}</td>
                                <td>${parseFloat(servicio.tarifa).toFixed(2)}</td>
                            </tr>
                        `;
                    });

                    // Agregar fila de total
                    tabla.innerHTML += `
                        <tr>
                            <td colspan="2"><strong>Total</strong></td>
                            <td><strong>${total.toFixed(2)}</strong></td>
                        </tr>
                    `;
                }
            </script>
        </head>
        <body>

            <div id="menu-grupos">
                <strong>Menú de Grupos:</strong>
    <?php
    // Imprimir menú de grupos basado en los datos
    foreach ($tree as $grupoCodigo => $grupo) {
        echo "<a href='#grupo-$grupoCodigo'>[$grupoCodigo] {$grupo['titulo']}</a>";
    }
    ?>
            </div>

            <div id="tabla-seleccionados">
                <h3>Servicios seleccionados:</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Nombre</th>
                            <th>Tarifa</th>
                        </tr>
                    </thead>
                    <tbody id="servicios-seleccionados"></tbody>
                </table>
            </div>
    <?php
    // Generar la vista en HTML
    echo "<ul>";
    foreach ($tree as $grupoCodigo => $grupo) {
        echo "<li id='grupo-$grupoCodigo' class='nivel-0'>[$grupoCodigo] {$grupo['titulo']}</li><ul>";
        foreach ($grupo['portafolios'] as $portafolioCodigo => $portafolio) {
            echo "<li class='nivel-1'>[$portafolioCodigo] {$portafolio['titulo']}</li><ul>";

            // Tabla de servicios
            echo "<li class='nivel-2'><table class='tabla-servicios'>";
            echo "<thead><tr><th>Código</th><th>Nombre</th><th>Tarifa</th></tr></thead><tbody>";
            foreach ($portafolio['servicios'] as $servicio) {
                $destacados = $servicio['destacados'];
                echo "<tr>";
                echo "<td>" . htmlspecialchars($destacados['CODIGO_SERVICIO']) . "</td>";
                echo "<td><a href='#' onclick=\"agregarServicio('{$destacados['CODIGO_SERVICIO']}', '{$destacados['NOMBRE_SERVICIO']}', '{$destacados['PESOS_TARIFA']}')\">" . htmlspecialchars($destacados['NOMBRE_SERVICIO']) . "</a></td>";
                echo "<td>" . htmlspecialchars($destacados['PESOS_TARIFA']) . "</td>";
                echo "</tr>";
            }
            echo "</tbody></table></li>";

            echo "</ul>";
        }
        echo "</ul>";
    }
    echo "</ul>";
} else {
    echo "No se encontraron resultados.";
}

// Cerrar la conexión
$conn->close();
?>
    </body>
</html>
