<?php
require_once '../../conexion_sicam_produccion.php';

$MatriculasLiquidar = [];
$matriculas = ['260971' => ['matricula' => '260971', 'activos' => '54400000'], '260972' => ['matricula' => '260972', 'activos' => '10520000']];
foreach ($MatriculasLiquidar as $Matricula) {
    array_push($matriculas, ['matricula' => $Matricula['matricula'], 'activos' => $Matricula['activos'], 'personal' => isset($Matricula['personal']) ? $Matricula['personal'] : 0]);
}

//$Respuesta = SiiConfecamaras::liquidarRenovacionNormalVariasMatriculas($matriculas);
$Respuesta = liquidarRenovacionNormalVariasMatriculas($matriculas);
//print_r($Respuesta);
header('Content-Type: application/json; charset=utf-8');
if ($Respuesta) {
    echo RespuestasSistema::exito('', $Respuesta);
}else{
    echo RespuestasSistema::error("Hubo un error al momento de generar la liquidación.", $Respuesta);
}




function liquidarRenovacionNormalVariasMatriculas($matriculas, $incluircertificado = 'S', $incluirformulario = 'S', $incluirafiliacion = 'S') {
    if (empty($matriculas)) {
        return RespuestasSistema::error('Se debe enviar la MATRICULA para buscar.');
    }

    $ApiSII = RegistrosSII::crearObjeto();
    $ApiSII->solicitarToken();
    $ApiSII = RegistrosSII::crearObjeto();
    $datosOperacion['codigoempresa'] = $ApiSII::codigoempresa;
    $datosOperacion['usuariows'] = $ApiSII::usuariows;
    $datosOperacion['token'] = $ApiSII::$token_activado;

    $datos = [];
    $operacion = 'liquidarRenovacionNormal';
    $result = null;
    $datosOperacion['idusuario'] = 'USUPUBXX';
    $datosOperacion['emailcontrol'] = 'USUPUBXX';
    $datosOperacion['celularcontrol'] = 'USUPUBXX';
    $datosOperacion['nombrecontrol'] = 'USUPUBXX';
    $datosOperacion['identificacioncontrol'] = 'USUPUBXX';
    $datosOperacion['incluirafiliacion'] = 'S';
    $datosOperacion['incluircertificado'] = 'N';
    $datosOperacion['incluirformulario'] = 'S';
    $datosOperacion['cumple1780'] = 'S';
    $datosOperacion['mantiene1780'] = 'S';
    $datosOperacion['renuncia1780'] = 'N';

    $datosOperacion['matriculas'] = $matriculas;

//        print_r($datosOperacion);

    $datosCompletos = array_merge($datos, $datosOperacion);
    $datosCompletos['operacion'] = $operacion;
    $url = "https://siisantamarta.confecamaras.co/librerias/wsRestSII/v1/";
    $data_string = json_encode($datosCompletos);
//        print_r($data_string);
    $ch = curl_init($url . $operacion);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt(
            $ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json',
        'Content-Length: ' . strlen($data_string)
            )
    );
    $result = curl_exec($ch);
    return (($result));
    $codigoerror = "0000";
    if (!empty($result)) {
        $Respuesta = json_decode($result);
        if (json_last_error() == JSON_ERROR_NONE) {
            foreach ($Respuesta as $key => $value) {
                $key = $value;
            }
            if ($codigoerror == '0000') {
                return $Respuesta;
            }
        }
    }
    return null;
}



function limpiarJson($json) {
    // Elimina los espacios y caracteres no visibles al inicio y al final
    $json = trim($json);

    // Elimina cualquier carácter extraño (no alfanumérico) al principio o final
    $json = preg_replace('/^[^\{]*\{/', '{', $json); // Elimina caracteres antes de {
    $json = preg_replace('/\}[^\}]*$/', '}', $json); // Elimina caracteres después de }

    return $json;
}