<?php
$permitidas = [
    'sicam32.net', 'tiendasicam32.net', 'citurcam.com', 
    'tramites-seguros.net', 'tramites-seguros.com',     
    'vpsicam.co', 'cloudflare.com' , 'citurcam.com',
    'api.citurcam.com', 'monitor.citurcam.com', 'qr.citurcam.com'
];

$originENTRANDO = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : $_SERVER['HTTP_HOST'];
$origin = 'null';

foreach ($permitidas as $url) {
    if (strpos($originENTRANDO, $url) !== false) {  // ✅ Corrección aquí
        $origin = $originENTRANDO;
        break;
    }
}

header('Access-Control-Allow-Origin: ' . $origin);
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Headers: X-Requested-With, Content-Type, Accept, Origin, Authorization, X-API-KEY, Access-Control-Request-Method');
header("Allow: GET, POST, OPTIONS, PUT, DELETE");
header('Access-Control-Allow-Methods: POST, OPTIONS, GET, PUT');
header('Access-Control-Max-Age: 1');
header("Strict-Transport-Security: max-age=60 ; includeSubDomains");
header("X-Frame-Options: ALLOW-FROM https://sicam32.net"); // ✅ Corrección aquí
header("X-XSS-Protection: 0");
header("X-Content-Type-Options: nosniff");

// ✅ Se agregó cdnsicam.net a script-src
header("Content-Security-Policy: script-src data: 'unsafe-eval' 'unsafe-inline' blob: data: static.cloudflareinsights.com cdnsicam.net cdnjs.cloudflare.com cdn.datatables.net cdn.jsdelivr.net www.amcharts.com api.mapbox.com *.userway.org *.freshchat.com *.freshworks.com *.google-analytics.com *.googleapis.com *.googlesyndication.com *.googletagmanager.com *.googleadservices.com *.google.com *.google.com.co *.gstatic.com monitor.citurcam.com *.citurcam.com citurcam.com *.tramites-seguros.net tramites-seguros.net  *.tramites-seguros.com tramites-seguros.com *.tiendasicam32.net tiendasicam32.net cliente.api.sicam32.net api.sicam32.net si.sicam32.net *.sicam32.net sicam32.net " . $origin);

header("X-Permitted-Cross-Domain-Policies: none");
header("Referrer-Policy: no-referrer");
header("Cross-Origin-Opener-Policy: same-origin");
header("Cross-Origin-Resource-Policy: " . $origin);
header("Cache-Control: no-store, max-age=30");
header("Pragma: no-cache");
