<?php
/**
 * File containing the abstract ezcDocumentOdtStylePropertyGenerator base class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Document
 * @version //autogen//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @access private
 */

/**
 * Base class for property generators.
 *
 * A property generator creates a certain style property and is capable of 
 * applying the style information handled by this property type Base class for 
 * property generators.
 *
 * @package Document
 * @access private
 * @version //autogen//
 */
abstract class ezcDocumentOdtStylePropertyGenerator
{
    /**
     * List of CSS style names to apply to the property. 
     * 
     * @var array(string)
     */
    protected $styleAttributes = array();

    /**
     * Style converters to be used. 
     * 
     * @var ezcDocumentOdtPcssConverterManager
     */
    protected $styleConverters;

    /**
     * Creates a new property generator.
     *
     * Must be overwritten by the actual implementation to fill the list of 
     * $styles to be applied to the property.
     * 
     * @param ezcDocumentOdtPcssConverterManager $styleConverters
     * @param array $styleAttributes
     */
    public function __construct( ezcDocumentOdtPcssConverterManager $styleConverters, array $styleAttributes )
    {
        $this->styleConverters = $styleConverters;
        $this->styleAttributes = $styleAttributes;
    }

    /**
     * Creates the style property from the attributes in $style.
     *
     * Creates the property generated by the specific style generator and 
     * renders all suitable styling attributes in $style into this property. 
     * The method {@link applyStyleAttributes()} can be used for easy 
     * application of all styles registered in the $styleAttributes property. 
     * 
     * @param DOMElement $parent 
     * @param array $styles 
     * @return DOMElement The created property
     */
    public abstract function createProperty( DOMElement $parent, array $styles );

    /**
     * Applies corresponding style attributes to the given property.
     * 
     * @param DOMElement $property 
     * @param array $styles
     */
    protected function applyStyleAttributes( DOMElement $property, array $styles )
    {
        foreach ( $this->styleAttributes as $handledStyleName )
        {
            if ( isset( $styles[$handledStyleName] ) && isset( $this->styleConverters[$handledStyleName] ) )
            {
                $this->styleConverters[$handledStyleName]->convert(
                    $property,
                    $handledStyleName,
                    $styles[$handledStyleName]
                );
            }
        }
    }
}

?>
