<?php

/**
 * 
 * CONEXION ENTRE UNA APLICACION PHP Y UN SERVIDOR SICAM DE LA CCSM 
 * @Fecha: 2022 marzo 26 
 * @Autor: Ing. Juan Pablo Llinás Ramírez 
 * @Email: jpllinas@ccsm.org.co 
 * @Version: 6.0 
 * Clase para conectar una aplicacion PHP con un servidor SICAM 
 * * Uso del patron de diseño Singleton para garantizar la correcta y unica instanciacion de la clase 
 * 
 */
class ApiSICAM {

  const MOSTRAR_RESPUESTA_API = false;
  const URL = "https://api.sicam32.net/";
  const USERNAME = "AVP7Th+PDAlma3BsUBTiZuhntObUfb0QdkTWxOdenVgtD4xmkYauvPOcAdk98TDx";
  const PASSWORD = "j9hYRNWz/XFn3RTfaz2jT8z2Wa7QPzmQiJCHmRZhQrc=";

  private $conexionApi = null;
  private static $instancia;
  private $JSONRespuesta = null;
  private $estadoConexion = false;
  private $resultado;

  public static function ObjetoAPI() {
    if (!isset(self::$instancia)) {
      $obj = __CLASS__;
      self::$instancia = new $obj;
    } return self::$instancia;
  }

  public function __construct() {
    
  }

  private function __clone() {
    throw new Exception("Este objeto no se puede clonar");
  }

  public function ejecutarPOST($componente, $controlador, $operacion, array $parametros = null) {
    return $this->ejecutarRESPUESTAsoloDATOS($componente, $controlador, $operacion, $parametros, "POST");
  }

  public function ejecutarGET($componente, $controlador, $operacion, array $parametros = null) {
    return $this->ejecutarRESPUESTAsoloDATOS($componente, $controlador, $operacion, $parametros, "GET");
  }

  public function ejecutarRESPUESTAsoloDATOS($componente, $controlador, $operacion, array $parametros = null, $metodo = "POST", $formato = "DATOS") {
    $JSONRespuesta = null;
    $estadoConexion = false;
    $this->conexionApi = curl_init();
    curl_setopt($this->conexionApi, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($this->conexionApi, CURLOPT_USERPWD, self::USERNAME . ":" . self::PASSWORD);
    curl_setopt($this->conexionApi, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($this->conexionApi, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($this->conexionApi, CURLOPT_RETURNTRANSFER, true);
    $urlCompleta = self::URL . $componente . "/" . $controlador . "/" . $operacion;
    if (!is_null($parametros)) {
      $data_string = json_encode($parametros);
      curl_setopt($this->conexionApi, CURLOPT_CUSTOMREQUEST, $metodo);
      curl_setopt($this->conexionApi, CURLOPT_POSTFIELDS, $data_string);
      curl_setopt($this->conexionApi, CURLOPT_HTTPHEADER, array("Accept: application/json", "Content-Type: application/json", "Content-Length: " . strlen($data_string)));
    } curl_setopt($this->conexionApi, CURLOPT_URL, $urlCompleta);
    $resultado = curl_exec($this->conexionApi);
    if (ApiSICAM::MOSTRAR_RESPUESTA_API) {
      echo " \n\n-->>> respondiendo por SOLO DATOS-->>\n\n";
      print_r($resultado);
    }
    $respuesta = json_decode($resultado);
//    echo " \n\n-->>> respondiendo DESPUIES DE TRANSFORMAR  -->>\n\n";
//    print_r($respuesta);
    if (json_last_error() === JSON_ERROR_NONE) {
      if (!session_status() == PHP_SESSION_ACTIVE) {
        session_start();
      }
      $estadoConexion = $_SESSION["API_CONEXION"] = true;
      //session_write_close();
      $info = curl_getinfo($this->conexionApi);
      if ($respuesta->RESPUESTA == "EXITO") {
        $JSONRespuesta = $respuesta->DATOS;
//        echo " \n\n-->>> respondiendo CON DATOS  -->>\n\n";
//        print_r($respuesta);
      } else {
        $JSONRespuesta = $respuesta->MENSAJE;
      }
    } else {
      $JSONRespuesta = "Error en el formato o contenido de la respuesta: " . json_last_error_msg();
    }
    $this->desconectar();
    return $JSONRespuesta;
  }

  public function ejecutar($componente, $controlador, $operacion, array $parametros = null, $metodo = "POST", $formato = "COMPLETA") {
    $JSONRespuesta = $this->formatearRespuesta(
        $this->solicitarDatos(
            $this->conectar($componente, $controlador, $operacion),
            $parametros, $metodo
        ),
        $formato
    );
    $this->desconectar();
    return $JSONRespuesta;
  }

  function conectar($componente, $controlador, $operacion) {
    $this->conexionApi = curl_init();
    curl_setopt($this->conexionApi, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($this->conexionApi, CURLOPT_USERPWD, self::USERNAME . ":" . self::PASSWORD);
    curl_setopt($this->conexionApi, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($this->conexionApi, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($this->conexionApi, CURLOPT_RETURNTRANSFER, true);
    return $urlCompleta = self::URL . $componente . "/" . $controlador . "/" . $operacion;
  }

  function solicitarDatos($urlCompleta, $parametros, $metodo) {
    if (!is_null($parametros)) {
      $data_string = json_encode($parametros);
      curl_setopt($this->conexionApi, CURLOPT_CUSTOMREQUEST, $metodo);
      curl_setopt($this->conexionApi, CURLOPT_POSTFIELDS, $data_string);
      curl_setopt($this->conexionApi, CURLOPT_HTTPHEADER, array("Accept: application/json", "Content-Type: application/json", "Content-Length: " . strlen($data_string)));

      if (ApiSICAM::MOSTRAR_RESPUESTA_API) {
        echo " \n\n-->>> copnsultando -->>\n\n";
        print_r([$urlCompleta, $parametros, $metodo]);
      }
    }
    curl_setopt($this->conexionApi, CURLOPT_URL, $urlCompleta);
    return $this->resultado = curl_exec($this->conexionApi);
  }

  function formatearRespuesta($resultado, $formato = "COMPLETA") {
    if (ApiSICAM::MOSTRAR_RESPUESTA_API) {
      echo " \n\n-->>> respondiendo por formaterRespuesta -->>\n\n";
      print_r(curl_getinfo($this->conexionApi));
      print_r($resultado);
    }
    $respuesta = json_decode($resultado);
//    print_r($respuesta);
    if (json_last_error() === JSON_ERROR_NONE) {
      if (!session_status() == PHP_SESSION_ACTIVE) {
        session_start();
      }
      $this->estadoConexion = $_SESSION["API_CONEXION"] = true;
      session_write_close();
      $this->info = curl_getinfo($this->conexionApi);

      switch ($formato) {
        case "COMPLETA":
          return $this->JSONRespuesta = $respuesta;
          break;
        case "DATOS":
        default:
          if ($respuesta->RESPUESTA == "EXITO") {
            return $this->JSONRespuesta = $respuesta->DATOS;
          } else {
            return $this->JSONRespuesta = $respuesta->MENSAJE;
          }
          break;
      }
    } else {
      $Error = new stdClass();
      $Error->RESPUESTA = "ERROR";
      $Error->MENSAJE = 'Error en el formato o contenido de la respuesta: [' . json_last_error_msg() . '].  ' . $resultado . '';
      return $this->JSONRespuesta = $Error;
    }
  }

  public function desconectar() {
    return curl_close($this->conexionApi);
  }

}

/**
 * Description of Respuestas
 *
 * @Autor: Ing. Juan Pablo Llinás Ramírez 
 * @Email: jpllinas@ccsm.org.co 
 */
class RespuestasSistema {

  //put your code here
  const EXITO = 'EXITO';
  const INFO = 'INFO';
  const FALLO = 'FALLO';
  const ALERTA = 'ALERTA';
  const ERROR = 'ERROR';

  public static function enJSON($respuesta, $mensaje, $datos = null, $error = null) {
    header('Content-Type: application/json; charset=utf-8');
    echo self::respuesta($respuesta, $mensaje, $datos);
  }

  public static function respuesta($respuesta, $mensaje, $datos = null, $codigo = null, $error = null) {
    if (!empty($mensaje)) {
      $mensaje = "" . $mensaje . "";
    }
    if (is_null($error)) {
      $error = $codigo;
    }
    $arrayRespuesta = array(
        'RESPUESTA' => $respuesta,
        'MENSAJE' => $mensaje,
        'DATOS' => $datos,
        'CODIGO' => $codigo,
        'ERROR' => $error
    );
    $jsonRespuesta = json_encode($arrayRespuesta);
    return $jsonRespuesta;
  }

  static public function exito($mensaje = null, $datos = null) {
    if (is_array($mensaje)) {
      $tmp = $datos;
      $datos = $mensaje;
      $mensaje = "";
    }

    if (is_object($mensaje)) {
      $array = (array) $mensaje;
      $mensaje = "";
      $datos = $array;
    }
    return self::respuesta(self::EXITO, $mensaje, $datos);
  }

  static public function alerta($mensaje, $datos = null) {
    return self::respuesta(self::ALERTA, $mensaje, $datos);
  }

  static public function fallo($mensaje, $datos = null) {
    return self::respuesta(self::FALLO, $mensaje, $datos);
  }

  static public function error($mensaje, $codigo = null, $datos = null) {
    return self::respuesta(self::ERROR, $mensaje, $datos, $codigo);
  }

  static public function informacion($mensaje, $datos = null) {
    if (is_array($mensaje)) {
      $tmp = $datos;
      $datos = $mensaje;
      $mensaje = "";
    }

    if (is_object($mensaje)) {
      $array = (array) $mensaje;
      $mensaje = "";
      $datos = $array;
    }
    return self::respuesta(self::INFO, $mensaje, $datos);
  }

  public static function getRespuesta() {
    return self::$respuesta;
  }

  public static function getMensajeRespuesta() {
    return self::$mensaje;
  }

}

$Api = ApiSICAM::ObjetoAPI();
