//objeto app
var ApiSicam = {};
ApiSicam.clavePublica = "<?= $Autenticador->Datos['usuarioENCRIPTADO'] ?>";
ApiSicam.clavePrivada = "<?= $Autenticador->Datos['claveENCRIPTADA'] ?>";
ApiSicam.url = "<?=URL_API?>";
ApiSicam.ejecutar = function (operacion, datos, accion) {
    return obtenerDatosAPi(operacion, datos, accion);
}
ApiSicam.ejecutarPost = function (operacion, datos, accion) {
    return ejecutarPostAPI(operacion, datos, accion);
}
ApiSicam.ejecutarPostAPIFormData = function (operacion, datos, accion) {
    return ejecutarPostAPIFormData(operacion, datos, accion);
}
function crearObjetoGestionConexion(accionDespuesConsulta = null, respuestaSoloDatos = true) {
    var ajax;
    if (window.XMLHttpRequest) {
        ajax = new XMLHttpRequest();
    } else if (window.ActiveXObject) {
        ajax = new ActiveXObject("Microsoft.XMLHttp");
    }
    ajax.withCredentials = true;
    ajax.onreadystatechange = function (data) {
        switch (ajax.readyState) {
            case 4:
                return validarEstadoPeticion(this);
                break;
        }
    };
    ajax.onload = function (data) {
        if (validarEstadoPeticion(this)) {
            try {
                var respuesta = JSON.parse(this.responseText);
            } catch (e) {
                console.log("La respuesta de la API no cumple con un formato valido.");
                console.log(this.responseText);
                console.log("Error");
                console.log(e);
            }
            try {
                if (accionDespuesConsulta) {
                    if (respuestaSoloDatos) {
                        accionDespuesConsulta(respuesta.DATOS);
                    } else {
                        accionDespuesConsulta(respuesta);
                    }
                }
            } catch (e) {
                console.log("Error en la ejecucion de la funcion de respuesta / callback.");
                console.log(accionDespuesConsulta);
                console.log("Error");
                console.log(e);
                console.log("Sys");
                console.log(this);
                console.log("Data");
                console.log(data);
            }
        }
    };
    ajax.error = function (request, status, error) {
        console.log("error en la conexion ajax.");
        console.log(request);
        console.log(status);
        console.log(error);
    };
    return ajax;
}
function obtenerDatosAPi(operacion, parametros = array(), accionDespuesConsulta = null, asincronico = true) {
    var ObjAjax = crearObjetoGestionConexion(accionDespuesConsulta);
    var url_operacion = ApiSicam.url + operacion;
    if (parametros) {
        for (var posicion in parametros) {
            if (parametros[posicion]) {
                url_operacion += "/" + parametros[posicion];
            }
        }
    }
    if (ObjAjax) {
        console.log(url_operacion);
        ObjAjax.open("GET", url_operacion, asincronico, ApiSicam.clavePublica, ApiSicam.clavePrivada);
        ObjAjax.setRequestHeader("Authorization", 'Basic ' + btoa(ApiSicam.clavePublica + ':' + ApiSicam.clavePrivada));
        ObjAjax.setRequestHeader('Content-Type', 'application/json');
        try {
            ObjAjax.send();
        } catch (e) {
            console.log('error en el SEND');
            console.log(e);
            ObjAjax.abort();
        }
}
}
function ejecutarPostAPI(operacion, parametros, accionDespuesConsulta = null, asincronico = true) {
    var ObjAjax = crearObjetoGestionConexion(accionDespuesConsulta, false);
    var url_operacion = ApiSicam.url + operacion;
    if (ObjAjax) {
        console.log(url_operacion);
        ObjAjax.open("POST", url_operacion, asincronico, ApiSicam.clavePublica, ApiSicam.clavePrivada);
        ObjAjax.setRequestHeader("Authorization", 'Basic ' + btoa(ApiSicam.clavePublica + ':' + ApiSicam.clavePrivada));
        ObjAjax.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        try {
            console.log(parametros);
            ObjAjax.send(parametros);
        } catch (e) {
            console.log('error en el SEND');
            console.log(e);
            ObjAjax.abort();
        }
}
}
function ejecutarPostAPIFormData(operacion, parametros, accionDespuesConsulta = null, asincronico = true) {
    var ObjAjax = crearObjetoGestionConexion(accionDespuesConsulta, false);
    var url_operacion = ApiSicam.url + operacion;
    if (ObjAjax) {
        console.log(url_operacion);
        ObjAjax.open("POST", url_operacion, asincronico, ApiSicam.clavePublica, ApiSicam.clavePrivada);
        ObjAjax.setRequestHeader("Authorization", 'Basic ' + btoa(ApiSicam.clavePublica + ':' + ApiSicam.clavePrivada));
        //ObjAjax.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        try {
            console.log(parametros);
            ObjAjax.send(parametros);
        } catch (e) {
            console.log('error en el SEND');
            console.log(e);
            ObjAjax.abort();
        }
}
}
function validarEstadoPeticion(ajax) {
    switch (ajax.status) {
        case 200:
//            console.log("Exito");
            return true;
            break;
        case 401:
            console.log("Fallo autenticación.");
            break;
        case 404:
            console.log("No existe la ruta.");
            break;
        case 405:
            console.log("Metodo REST no permitido para la operación.");
            break;
        case 500:
            console.log("Error en el Servidor.");
            break;
        default:
            console.log("Respuesta desconocida.");
            break;
    }
    if (typeof desbloqueoCargando === "function") {
        desbloqueoCargando();
    }
    ajax.abort();
    return false;
}
window.addEventListener ? window.addEventListener("load", ApiSicam, !1) : window.attachEvent("load", ApiSicam, !1);