/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.pattern;

import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.exception.AlignmentPatternNotFoundException;
import jp.sourceforge.qrcode.exception.InvalidVersionException;
import jp.sourceforge.qrcode.geom.Axis;
import jp.sourceforge.qrcode.geom.Line;
import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.pattern.FinderPattern;
import jp.sourceforge.qrcode.pattern.LogicalSeed;
import jp.sourceforge.qrcode.util.DebugCanvas;

public class AlignmentPattern {
    static final int RIGHT = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 3;
    static final int TOP = 4;
    static DebugCanvas canvas = QRCodeDecoder.getCanvas();
    Point[][] center;
    int patternDistance;

    AlignmentPattern(Point[][] pointArray, int n) {
        this.center = pointArray;
        this.patternDistance = n;
    }

    public static AlignmentPattern findAlignmentPattern(boolean[][] blArray, FinderPattern finderPattern) throws AlignmentPatternNotFoundException, InvalidVersionException {
        Point[][] pointArray = AlignmentPattern.getLogicalCenter(finderPattern);
        int n = pointArray[1][0].getX() - pointArray[0][0].getX();
        Point[][] pointArray2 = null;
        pointArray2 = AlignmentPattern.getCenter(blArray, finderPattern, pointArray);
        return new AlignmentPattern(pointArray2, n);
    }

    public Point[][] getCenter() {
        return this.center;
    }

    public void setCenter(Point[][] pointArray) {
        this.center = pointArray;
    }

    public int getLogicalDistance() {
        return this.patternDistance;
    }

    static Point[][] getCenter(boolean[][] blArray, FinderPattern finderPattern, Point[][] pointArray) throws AlignmentPatternNotFoundException {
        int n = finderPattern.getModuleSize();
        Axis axis = new Axis(finderPattern.getAngle(), n);
        int n2 = pointArray.length;
        Point[][] pointArray2 = new Point[n2][n2];
        axis.setOrigin(finderPattern.getCenter(0));
        pointArray2[0][0] = axis.translate(3, 3);
        canvas.drawCross(pointArray2[0][0], 0x8888FF);
        axis.setOrigin(finderPattern.getCenter(1));
        pointArray2[n2 - 1][0] = axis.translate(-3, 3);
        canvas.drawCross(pointArray2[n2 - 1][0], 0x8888FF);
        axis.setOrigin(finderPattern.getCenter(2));
        pointArray2[0][n2 - 1] = axis.translate(3, -3);
        canvas.drawCross(pointArray2[0][n2 - 1], 0x8888FF);
        Point point = pointArray2[0][0];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                Point point2;
                if (j == 0 && i == 0 || j == 0 && i == n2 - 1 || j == n2 - 1 && i == 0) continue;
                Point point3 = null;
                if (i == 0) {
                    if (j > 0 && j < n2 - 1) {
                        point3 = axis.translate(pointArray2[j - 1][i], pointArray[j][i].getX() - pointArray[j - 1][i].getX(), 0);
                        pointArray2[j][i] = new Point(point3.getX(), point3.getY());
                        canvas.drawCross(pointArray2[j][i], 0xFF88888);
                    }
                } else if (j == 0) {
                    if (i > 0 && i < n2 - 1) {
                        point3 = axis.translate(pointArray2[j][i - 1], 0, pointArray[j][i].getY() - pointArray[j][i - 1].getY());
                        pointArray2[j][i] = new Point(point3.getX(), point3.getY());
                        canvas.drawCross(pointArray2[j][i], 0xFF88888);
                    }
                } else {
                    point2 = axis.translate(pointArray2[j - 1][i], pointArray[j][i].getX() - pointArray[j - 1][i].getX(), 0);
                    Point point4 = axis.translate(pointArray2[j][i - 1], 0, pointArray[j][i].getY() - pointArray[j][i - 1].getY());
                    pointArray2[j][i] = new Point((point2.getX() + point4.getX()) / 2, (point2.getY() + point4.getY()) / 2 + 1);
                }
                if (finderPattern.getVersion() > 1) {
                    point2 = AlignmentPattern.getPrecisionCenter(blArray, pointArray2[j][i]);
                    canvas.drawCross(pointArray2[j][i], 0xFF88888);
                    int n3 = point2.getX() - pointArray2[j][i].getX();
                    int n4 = point2.getY() - pointArray2[j][i].getY();
                    canvas.println("Adjust AP(" + j + "," + i + ") to d(" + n3 + "," + n4 + ")");
                    pointArray2[j][i] = point2;
                }
                canvas.drawCross(pointArray2[j][i], 0x8888FF);
                canvas.drawLine(new Line(point, pointArray2[j][i]), 0xBBBBFF);
                point = pointArray2[j][i];
            }
        }
        return pointArray2;
    }

    static Point getPrecisionCenter(boolean[][] blArray, Point point) throws AlignmentPatternNotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = point.getX();
        int n8 = point.getY();
        if (n7 < 0 || n8 < 0 || n7 > blArray.length - 1 || n8 > blArray[0].length - 1) {
            throw new AlignmentPatternNotFoundException("Alignment Pattern finder exceeded out of image");
        }
        if (!blArray[point.getX()][point.getY()]) {
            n6 = 0;
            n5 = 0;
            while (n5 == 0) {
                for (n4 = ++n6; n4 > -n6; --n4) {
                    for (n3 = n6; n3 > -n6; --n3) {
                        n2 = point.getX() + n3;
                        n = point.getY() + n4;
                        if (n2 < 0 || n < 0 || n2 > blArray.length - 1 || n > blArray[0].length - 1) {
                            throw new AlignmentPatternNotFoundException("Alignment Pattern finder exceeded out of image");
                        }
                        if (!blArray[n2][n]) continue;
                        point = new Point(point.getX() + n3, point.getY() + n4);
                        canvas.drawPoint(point, 0xFF88888);
                        n5 = 1;
                    }
                }
            }
        }
        n6 = n4;
        n2 = n = point.getY();
        n3 = n;
        for (n5 = n4 = point.getX(); n5 >= 1 && !AlignmentPattern.targetPointOnTheCorner(blArray, n5, n3, n5 - 1, n3); --n5) {
        }
        while (n4 < blArray.length - 1 && !AlignmentPattern.targetPointOnTheCorner(blArray, n4, n3, n4 + 1, n3)) {
            ++n4;
        }
        while (n2 >= 1 && !AlignmentPattern.targetPointOnTheCorner(blArray, n6, n2, n6, n2 - 1)) {
            --n2;
        }
        while (n < blArray[0].length - 1 && !AlignmentPattern.targetPointOnTheCorner(blArray, n6, n, n6, n + 1)) {
            ++n;
        }
        return new Point((n5 + n4 + 1) / 2, (n2 + n + 1) / 2);
    }

    static boolean targetPointOnTheCorner(boolean[][] blArray, int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n > blArray.length || n2 > blArray[0].length || n3 > blArray.length || n4 > blArray[0].length) {
            throw new AlignmentPatternNotFoundException("Alignment Pattern Finder exceeded image edge");
        }
        return !blArray[n][n2] && blArray[n3][n4];
    }

    public static Point[][] getLogicalCenter(FinderPattern finderPattern) {
        int n = finderPattern.getVersion();
        Point[][] pointArray = new Point[1][1];
        int[] nArray = new int[1];
        nArray = LogicalSeed.getSeed(n);
        pointArray = new Point[nArray.length][nArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            for (int j = 0; j < pointArray.length; ++j) {
                pointArray[j][i] = new Point(nArray[j], nArray[i]);
            }
        }
        return pointArray;
    }
}

